package com.xforceplus.taxwarebananaservice.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-05-07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceMiMonitor implements Serializable {

  private static final long serialVersionUID=1L;

  @TableField("tenantCode")
  private String tenantCode;

  @TableField("sellerTaxCode")
  private String sellerTaxCode;

  @TableField("sellerName")
  private String sellerName;

  private String mi;

  @TableField("totalInvoiceCount")
  private Long totalInvoiceCount;

  @TableField("queueCount")
  private Long queueCount;

  @TableField("minEstimatedTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime minEstimatedTime;

  @TableField("maxEstimatedTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime maxEstimatedTime;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  private String cloud;

  @TableField("loadMode")
  private String loadMode;

  @TableField("inventoryNum")
  private Long inventoryNum;

  @TableField("makeMachineNo")
  private String makeMachineNo;

  @TableField("physicalMachineIp")
  private String physicalMachineIp;

  @TableField("rowCoordinate")
  private String rowCoordinate;

  @TableField("columnCoordinate")
  private String columnCoordinate;

  @TableField("onlineFlag")
  private String onlineFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("tenantCode", tenantCode);
      map.put("sellerTaxCode", sellerTaxCode);
      map.put("sellerName", sellerName);
      map.put("mi", mi);
      map.put("totalInvoiceCount", totalInvoiceCount);
      map.put("queueCount", queueCount);
      map.put("minEstimatedTime", BocpGenUtils.toTimestamp(minEstimatedTime));
      map.put("maxEstimatedTime", BocpGenUtils.toTimestamp(maxEstimatedTime));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("cloud", cloud);
      map.put("loadMode", loadMode);
      map.put("inventoryNum", inventoryNum);
      map.put("makeMachineNo", makeMachineNo);
      map.put("physicalMachineIp", physicalMachineIp);
      map.put("rowCoordinate", rowCoordinate);
      map.put("columnCoordinate", columnCoordinate);
      map.put("onlineFlag", onlineFlag);
      return map;
  }

  public static InvoiceMiMonitor fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    InvoiceMiMonitor entity = new InvoiceMiMonitor();
    if(map.containsKey("tenantCode")) {
      Object obj = map.get("tenantCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxCode")) {
      Object obj = map.get("sellerTaxCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mi")) {
      Object obj = map.get("mi");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMi((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalInvoiceCount")) {
      Object obj = map.get("totalInvoiceCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTotalInvoiceCount((Long)obj);
        } else if(obj instanceof String) {
          entity.setTotalInvoiceCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTotalInvoiceCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("queueCount")) {
      Object obj = map.get("queueCount");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setQueueCount((Long)obj);
        } else if(obj instanceof String) {
          entity.setQueueCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setQueueCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("minEstimatedTime")) {
      Object obj = map.get("minEstimatedTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMinEstimatedTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setMinEstimatedTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setMinEstimatedTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setMinEstimatedTime(null);
      }
    }
    if(map.containsKey("maxEstimatedTime")) {
      Object obj = map.get("maxEstimatedTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMaxEstimatedTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setMaxEstimatedTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setMaxEstimatedTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setMaxEstimatedTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cloud")) {
      Object obj = map.get("cloud");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCloud((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("loadMode")) {
      Object obj = map.get("loadMode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLoadMode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("inventoryNum")) {
      Object obj = map.get("inventoryNum");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInventoryNum((Long)obj);
        } else if(obj instanceof String) {
          entity.setInventoryNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setInventoryNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("makeMachineNo")) {
      Object obj = map.get("makeMachineNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMakeMachineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("physicalMachineIp")) {
      Object obj = map.get("physicalMachineIp");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPhysicalMachineIp((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rowCoordinate")) {
      Object obj = map.get("rowCoordinate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRowCoordinate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("columnCoordinate")) {
      Object obj = map.get("columnCoordinate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setColumnCoordinate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("onlineFlag")) {
      Object obj = map.get("onlineFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOnlineFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
