package com.xforceplus.taxwarebananaservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票类型枚举
 * </p>
 *
 * @author ultraman
 * @since 2021-06-28
 */
public enum InvoiceTypeEnum {

    C("c", "纸质普票"),
    CE("ce", "电子普票"),
    S("s", "纸质专票"),
    SE("se", "电子专票"),
    JU("ju", "纸质卷票"),
    V("v", "机动车票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceTypeEnum fromCode(String code){
        switch(code) {
            case "c":
                return C;
            case "ce":
                return CE;
            case "s":
                return S;
            case "se":
                return SE;
            case "ju":
                return JU;
            case "v":
                return V;
            default:
                return null;
        }
    }
}
