package com.xforceplus.taxwarebananaservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 税盘类型
 * </p>
 *
 * @author ultraman
 * @since 2021-06-28
 */
public enum VendorType {

    _1("1", "百望"),
    _2("2", "航信"),
    _4("4", "税务Ukey");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    VendorType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static VendorType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
