package com.xforceplus.taxwarebananaservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 预警级别
 * </p>
 *
 * @author ultraman
 * @since 2021-06-28
 */
public enum WarningLevel {

    LOW("low", "低"),
    NORMAL("normal", "中"),
    HIGH("high", "高"),
    SPECIAL("special", "特");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    WarningLevel(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static WarningLevel fromCode(String code){
        switch(code) {
            case "low":
                return LOW;
            case "normal":
                return NORMAL;
            case "high":
                return HIGH;
            case "special":
                return SPECIAL;
            default:
                return null;
        }
    }
}
