package com.xforceplus.taxwarebananaservice.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-06-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class MachineManage implements Serializable {

  private static final long serialVersionUID=1L;

  @TableField("rackNumber")
  private String rackNumber;

  @TableField("uLocation")
  private String uLocation;

  @TableField("operatingSystem")
  private String operatingSystem;

  private String type;

  private String useltem;

  private String ip;

  @TableField("computerName")
  private String computerName;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  private String remark;

  @TableField("remoteMode")
  private String remoteMode;

  @TableField("taxDiskType")
  private String taxDiskType;

  @TableField("purchaseDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime purchaseDate;

  @TableField("hubSupportRestart")
  private Boolean hubSupportRestart;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("rackNumber", rackNumber);
      map.put("uLocation", uLocation);
      map.put("operatingSystem", operatingSystem);
      map.put("type", type);
      map.put("useltem", useltem);
      map.put("ip", ip);
      map.put("computerName", computerName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("remark", remark);
      map.put("remoteMode", remoteMode);
      map.put("taxDiskType", taxDiskType);
      map.put("purchaseDate", BocpGenUtils.toTimestamp(purchaseDate));
      map.put("hubSupportRestart", hubSupportRestart);
      return map;
  }

  public static MachineManage fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    MachineManage entity = new MachineManage();
    if(map.containsKey("rackNumber")) {
      Object obj = map.get("rackNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRackNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("uLocation")) {
      Object obj = map.get("uLocation");
      if(obj != null) {
        if(obj instanceof String){
          entity.setULocation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("operatingSystem")) {
      Object obj = map.get("operatingSystem");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOperatingSystem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("type")) {
      Object obj = map.get("type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("useltem")) {
      Object obj = map.get("useltem");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUseltem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ip")) {
      Object obj = map.get("ip");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIp((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("computerName")) {
      Object obj = map.get("computerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setComputerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remoteMode")) {
      Object obj = map.get("remoteMode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemoteMode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxDiskType")) {
      Object obj = map.get("taxDiskType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxDiskType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseDate")) {
      Object obj = map.get("purchaseDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaseDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setPurchaseDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPurchaseDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPurchaseDate(null);
      }
    }
    if(map.containsKey("hubSupportRestart")) {
      Object obj = map.get("hubSupportRestart");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setHubSupportRestart((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setHubSupportRestart(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    return entity;
  }
}
