package com.xforceplus.taxwarebananaservice.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-06-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class TaxDevice implements Serializable {

  private static final long serialVersionUID=1L;

  @TableField("tenantCode")
  private String tenantCode;

  @TableField("onlineFlag")
  private String onlineFlag;

  @TableField("vendorType")
  private String vendorType;

  @TableField("companyName")
  private String companyName;

  @TableField("companyTaxCode")
  private String companyTaxCode;

  @TableField("invoicingMachineNo")
  private String invoicingMachineNo;

  @TableField("miAccount")
  private String miAccount;

  @TableField("miPassword")
  private String miPassword;

  @TableField("invoiceHelperAccount")
  private String invoiceHelperAccount;

  @TableField("invoiceHelperPassword")
  private String invoiceHelperPassword;

  @TableField("firstOnlineDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime firstOnlineDate;

  @TableField("onlineDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime onlineDate;

  @TableField("offlineDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime offlineDate;

  @TableField("certPassword")
  private String certPassword;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  private String dp;

  @TableField("offlineRemark")
  private String offlineRemark;

  @TableField("shopCode")
  private String shopCode;

  @TableField("deviceNo")
  private String deviceNo;

  private String remark;

  @TableField("warningLevel")
  private String warningLevel;

  @TableField("projectEnv")
  private String projectEnv;

  @TableField("columnCoordinate")
  private String columnCoordinate;

  @TableField("rowCoordinate")
  private String rowCoordinate;

  @TableField("onlineStartDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime onlineStartDate;

  @TableField("onlineEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime onlineEndDate;

  @TableField("onlineStartTime")
  private String onlineStartTime;

  @TableField("onlineEndTime")
  private String onlineEndTime;

  private String tolerance;

  @TableField("pdfDeclareTaxFile")
  private String pdfDeclareTaxFile;

  @TableField("xpsDeclareTaxFile")
  private String xpsDeclareTaxFile;

  @TableField("pdfDeclareTaxFileName")
  private String pdfDeclareTaxFileName;

  @TableField("xpsDeclareTaxFileName")
  private String xpsDeclareTaxFileName;

  @TableField("excelDeclareTaxFileName")
  private String excelDeclareTaxFileName;

  @TableField("excelDeclareTaxFile")
  private String excelDeclareTaxFile;

  @TableField("lockDate")
  private String lockDate;

  @TableField("offLineTimeLimit")
  private String offLineTimeLimit;

  @TableField("offLineAmountLimit")
  private BigDecimal offLineAmountLimit;

  @TableField("singleAmountLimit")
  private BigDecimal singleAmountLimit;

  @TableField("invoiceEstimatedTime")
  private Long invoiceEstimatedTime;

  @TableField("lockTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime lockTime;

  @TableField("declareTaxFileErrorMessage")
  private String declareTaxFileErrorMessage;

  @TableField("monthlyInvoiceNumber")
  private Long monthlyInvoiceNumber;

  @TableField("summaryYearMonth")
  private String summaryYearMonth;

  @TableField("excelExportMsg")
  private String excelExportMsg;

  @TableField("xpsOrXpsGenerateMsg")
  private String xpsOrXpsGenerateMsg;

  @TableField("declareTaxFileUploadTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime declareTaxFileUploadTime;

  @TableField("summaryReportMsg")
  private String summaryReportMsg;

  @TableField("remoteReportMsg")
  private String remoteReportMsg;

  @TableField("cleanCardResultTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime cleanCardResultTime;

  @TableField("stockThreshold")
  private Long stockThreshold;

  @TableField("loadMode")
  private String loadMode;

  @TableField("inventoryNum")
  private Long inventoryNum;

  @TableField("offlineStartDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime offlineStartDate;

  @TableField("offlineEndDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime offlineEndDate;

  @TableField("startTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime startTime;

  @TableField("endTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime endTime;

  @TableField("offlineStatus")
  private String offlineStatus;

  private String bp;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("tenantCode", tenantCode);
      map.put("onlineFlag", onlineFlag);
      map.put("vendorType", vendorType);
      map.put("companyName", companyName);
      map.put("companyTaxCode", companyTaxCode);
      map.put("invoicingMachineNo", invoicingMachineNo);
      map.put("miAccount", miAccount);
      map.put("miPassword", miPassword);
      map.put("invoiceHelperAccount", invoiceHelperAccount);
      map.put("invoiceHelperPassword", invoiceHelperPassword);
      map.put("firstOnlineDate", BocpGenUtils.toTimestamp(firstOnlineDate));
      map.put("onlineDate", BocpGenUtils.toTimestamp(onlineDate));
      map.put("offlineDate", BocpGenUtils.toTimestamp(offlineDate));
      map.put("certPassword", certPassword);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("dp", dp);
      map.put("offlineRemark", offlineRemark);
      map.put("shopCode", shopCode);
      map.put("deviceNo", deviceNo);
      map.put("remark", remark);
      map.put("warningLevel", warningLevel);
      map.put("projectEnv", projectEnv);
      map.put("columnCoordinate", columnCoordinate);
      map.put("rowCoordinate", rowCoordinate);
      map.put("onlineStartDate", BocpGenUtils.toTimestamp(onlineStartDate));
      map.put("onlineEndDate", BocpGenUtils.toTimestamp(onlineEndDate));
      map.put("onlineStartTime", onlineStartTime);
      map.put("onlineEndTime", onlineEndTime);
      map.put("tolerance", tolerance);
      map.put("pdfDeclareTaxFile", pdfDeclareTaxFile);
      map.put("xpsDeclareTaxFile", xpsDeclareTaxFile);
      map.put("pdfDeclareTaxFileName", pdfDeclareTaxFileName);
      map.put("xpsDeclareTaxFileName", xpsDeclareTaxFileName);
      map.put("excelDeclareTaxFileName", excelDeclareTaxFileName);
      map.put("excelDeclareTaxFile", excelDeclareTaxFile);
      map.put("lockDate", lockDate);
      map.put("offLineTimeLimit", offLineTimeLimit);
      map.put("offLineAmountLimit", offLineAmountLimit);
      map.put("singleAmountLimit", singleAmountLimit);
      map.put("invoiceEstimatedTime", invoiceEstimatedTime);
      map.put("lockTime", BocpGenUtils.toTimestamp(lockTime));
      map.put("declareTaxFileErrorMessage", declareTaxFileErrorMessage);
      map.put("monthlyInvoiceNumber", monthlyInvoiceNumber);
      map.put("summaryYearMonth", summaryYearMonth);
      map.put("excelExportMsg", excelExportMsg);
      map.put("xpsOrXpsGenerateMsg", xpsOrXpsGenerateMsg);
      map.put("declareTaxFileUploadTime", BocpGenUtils.toTimestamp(declareTaxFileUploadTime));
      map.put("summaryReportMsg", summaryReportMsg);
      map.put("remoteReportMsg", remoteReportMsg);
      map.put("cleanCardResultTime", BocpGenUtils.toTimestamp(cleanCardResultTime));
      map.put("stockThreshold", stockThreshold);
      map.put("loadMode", loadMode);
      map.put("inventoryNum", inventoryNum);
      map.put("offlineStartDate", BocpGenUtils.toTimestamp(offlineStartDate));
      map.put("offlineEndDate", BocpGenUtils.toTimestamp(offlineEndDate));
      map.put("startTime", BocpGenUtils.toTimestamp(startTime));
      map.put("endTime", BocpGenUtils.toTimestamp(endTime));
      map.put("offlineStatus", offlineStatus);
      map.put("bp", bp);
      return map;
  }

  public static TaxDevice fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    TaxDevice entity = new TaxDevice();
    if(map.containsKey("tenantCode")) {
      Object obj = map.get("tenantCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("onlineFlag")) {
      Object obj = map.get("onlineFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOnlineFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vendorType")) {
      Object obj = map.get("vendorType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVendorType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyTaxCode")) {
      Object obj = map.get("companyTaxCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanyTaxCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicingMachineNo")) {
      Object obj = map.get("invoicingMachineNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoicingMachineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("miAccount")) {
      Object obj = map.get("miAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMiAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("miPassword")) {
      Object obj = map.get("miPassword");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMiPassword((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceHelperAccount")) {
      Object obj = map.get("invoiceHelperAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceHelperAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceHelperPassword")) {
      Object obj = map.get("invoiceHelperPassword");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceHelperPassword((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("firstOnlineDate")) {
      Object obj = map.get("firstOnlineDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFirstOnlineDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setFirstOnlineDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setFirstOnlineDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setFirstOnlineDate(null);
      }
    }
    if(map.containsKey("onlineDate")) {
      Object obj = map.get("onlineDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOnlineDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setOnlineDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setOnlineDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOnlineDate(null);
      }
    }
    if(map.containsKey("offlineDate")) {
      Object obj = map.get("offlineDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOfflineDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setOfflineDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setOfflineDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOfflineDate(null);
      }
    }
    if(map.containsKey("certPassword")) {
      Object obj = map.get("certPassword");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCertPassword((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dp")) {
      Object obj = map.get("dp");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDp((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("offlineRemark")) {
      Object obj = map.get("offlineRemark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOfflineRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shopCode")) {
      Object obj = map.get("shopCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setShopCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deviceNo")) {
      Object obj = map.get("deviceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeviceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warningLevel")) {
      Object obj = map.get("warningLevel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWarningLevel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("projectEnv")) {
      Object obj = map.get("projectEnv");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProjectEnv((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("columnCoordinate")) {
      Object obj = map.get("columnCoordinate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setColumnCoordinate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rowCoordinate")) {
      Object obj = map.get("rowCoordinate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRowCoordinate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("onlineStartDate")) {
      Object obj = map.get("onlineStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOnlineStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setOnlineStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setOnlineStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOnlineStartDate(null);
      }
    }
    if(map.containsKey("onlineEndDate")) {
      Object obj = map.get("onlineEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOnlineEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setOnlineEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setOnlineEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOnlineEndDate(null);
      }
    }
    if(map.containsKey("onlineStartTime")) {
      Object obj = map.get("onlineStartTime");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOnlineStartTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("onlineEndTime")) {
      Object obj = map.get("onlineEndTime");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOnlineEndTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tolerance")) {
      Object obj = map.get("tolerance");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTolerance((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pdfDeclareTaxFile")) {
      Object obj = map.get("pdfDeclareTaxFile");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPdfDeclareTaxFile((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xpsDeclareTaxFile")) {
      Object obj = map.get("xpsDeclareTaxFile");
      if(obj != null) {
        if(obj instanceof String){
          entity.setXpsDeclareTaxFile((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pdfDeclareTaxFileName")) {
      Object obj = map.get("pdfDeclareTaxFileName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPdfDeclareTaxFileName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xpsDeclareTaxFileName")) {
      Object obj = map.get("xpsDeclareTaxFileName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setXpsDeclareTaxFileName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("excelDeclareTaxFileName")) {
      Object obj = map.get("excelDeclareTaxFileName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExcelDeclareTaxFileName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("excelDeclareTaxFile")) {
      Object obj = map.get("excelDeclareTaxFile");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExcelDeclareTaxFile((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lockDate")) {
      Object obj = map.get("lockDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLockDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("offLineTimeLimit")) {
      Object obj = map.get("offLineTimeLimit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOffLineTimeLimit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("offLineAmountLimit")) {
      Object obj = map.get("offLineAmountLimit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOffLineAmountLimit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOffLineAmountLimit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOffLineAmountLimit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setOffLineAmountLimit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOffLineAmountLimit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("singleAmountLimit")) {
      Object obj = map.get("singleAmountLimit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSingleAmountLimit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSingleAmountLimit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSingleAmountLimit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setSingleAmountLimit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSingleAmountLimit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceEstimatedTime")) {
      Object obj = map.get("invoiceEstimatedTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceEstimatedTime((Long)obj);
        } else if(obj instanceof String) {
          entity.setInvoiceEstimatedTime(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setInvoiceEstimatedTime(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("lockTime")) {
      Object obj = map.get("lockTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLockTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setLockTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setLockTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setLockTime(null);
      }
    }
    if(map.containsKey("declareTaxFileErrorMessage")) {
      Object obj = map.get("declareTaxFileErrorMessage");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeclareTaxFileErrorMessage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("monthlyInvoiceNumber")) {
      Object obj = map.get("monthlyInvoiceNumber");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMonthlyInvoiceNumber((Long)obj);
        } else if(obj instanceof String) {
          entity.setMonthlyInvoiceNumber(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setMonthlyInvoiceNumber(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("summaryYearMonth")) {
      Object obj = map.get("summaryYearMonth");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSummaryYearMonth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("excelExportMsg")) {
      Object obj = map.get("excelExportMsg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExcelExportMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xpsOrXpsGenerateMsg")) {
      Object obj = map.get("xpsOrXpsGenerateMsg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setXpsOrXpsGenerateMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("declareTaxFileUploadTime")) {
      Object obj = map.get("declareTaxFileUploadTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDeclareTaxFileUploadTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setDeclareTaxFileUploadTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setDeclareTaxFileUploadTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDeclareTaxFileUploadTime(null);
      }
    }
    if(map.containsKey("summaryReportMsg")) {
      Object obj = map.get("summaryReportMsg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSummaryReportMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remoteReportMsg")) {
      Object obj = map.get("remoteReportMsg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemoteReportMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cleanCardResultTime")) {
      Object obj = map.get("cleanCardResultTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCleanCardResultTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCleanCardResultTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCleanCardResultTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCleanCardResultTime(null);
      }
    }
    if(map.containsKey("stockThreshold")) {
      Object obj = map.get("stockThreshold");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStockThreshold((Long)obj);
        } else if(obj instanceof String) {
          entity.setStockThreshold(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setStockThreshold(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("loadMode")) {
      Object obj = map.get("loadMode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLoadMode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("inventoryNum")) {
      Object obj = map.get("inventoryNum");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInventoryNum((Long)obj);
        } else if(obj instanceof String) {
          entity.setInventoryNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setInventoryNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("offlineStartDate")) {
      Object obj = map.get("offlineStartDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOfflineStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setOfflineStartDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setOfflineStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOfflineStartDate(null);
      }
    }
    if(map.containsKey("offlineEndDate")) {
      Object obj = map.get("offlineEndDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOfflineEndDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setOfflineEndDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setOfflineEndDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOfflineEndDate(null);
      }
    }
    if(map.containsKey("startTime")) {
      Object obj = map.get("startTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStartTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setStartTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setStartTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStartTime(null);
      }
    }
    if(map.containsKey("endTime")) {
      Object obj = map.get("endTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEndTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setEndTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setEndTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEndTime(null);
      }
    }
    if(map.containsKey("offlineStatus")) {
      Object obj = map.get("offlineStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOfflineStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bp")) {
      Object obj = map.get("bp");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBp((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
