package com.xforceplus.taxwarebananaservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 客户端升级维度枚举
 * </p>
 *
 * @author ultraman
 * @since 2021-06-28
 */
public enum ConfigTypeEnum {

    GLOBAL("global", "全局"),
    TENANT("tenant", "租户"),
    TAX_CODE("taxCode", "税号"),
    DEVICE_NO("deviceNo", "设备编号");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ConfigTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ConfigTypeEnum fromCode(String code){
        switch(code) {
            case "global":
                return GLOBAL;
            case "tenant":
                return TENANT;
            case "taxCode":
                return TAX_CODE;
            case "deviceNo":
                return DEVICE_NO;
            default:
                return null;
        }
    }
}
