package com.xforceplus.taxwarebananaservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 客户端升级枚举值
 * </p>
 *
 * @author ultraman
 * @since 2021-06-29
 */
public enum ClientUpdateCodeEnum {

    NORMAL("normal", "强制升级"),
    SILENT("silent", "静默升级");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ClientUpdateCodeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ClientUpdateCodeEnum fromCode(String code){
        switch(code) {
            case "normal":
                return NORMAL;
            case "silent":
                return SILENT;
            default:
                return null;
        }
    }
}
