package com.xforceplus.taxwarebananaservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 领票策略
 * </p>
 *
 * @author ultraman
 * @since 2021-06-29
 */
public enum FetchingStrategyEnum {

    BY_TAX_DISK_COUNT("byTaxDiskCount", "均匀领票"),
    THRESHOLD("threshold", "阈值领票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    FetchingStrategyEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FetchingStrategyEnum fromCode(String code){
        switch(code) {
            case "byTaxDiskCount":
                return BY_TAX_DISK_COUNT;
            case "threshold":
                return THRESHOLD;
            default:
                return null;
        }
    }
}
