package com.xforceplus.taxwarebananaservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 掉线状态枚举字典
 * </p>
 *
 * @author ultraman
 * @since 2021-06-29
 */
public enum OfflineStatusEnum {

    OFFLINE("Offline", "离线中"),
    NORMAL("Normal", "已恢复");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    OfflineStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OfflineStatusEnum fromCode(String code){
        switch(code) {
            case "Offline":
                return OFFLINE;
            case "Normal":
                return NORMAL;
            default:
                return null;
        }
    }
}
