package com.xforceplus.taxwarebananaservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 上架标识
 * </p>
 *
 * @author ultraman
 * @since 2021-06-29
 */
public enum OnlineFlag {

    _1("1", "已启用"),
    _2("2", "待上架"),
    _3("3", "盘未查收"),
    _4("4", "下架"),
    _5("5", "永久下架"),
    _6("6", "未启用");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    OnlineFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OnlineFlag fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            default:
                return null;
        }
    }
}
