package com.xforceplus.taxwarebananaservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 产品枚举
 * </p>
 *
 * @author ultraman
 * @since 2021-06-29
 */
public enum ProductEnum {

    X_CLIENT("xClient", "统一客户端"),
    MINI_CLIENT("miniClient", "mini客户端");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ProductEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProductEnum fromCode(String code){
        switch(code) {
            case "xClient":
                return X_CLIENT;
            case "miniClient":
                return MINI_CLIENT;
            default:
                return null;
        }
    }
}
