package com.xforceplus.taxwarebananaservice.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-06-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class TaxDiskUsageStatistics implements Serializable {

  private static final long serialVersionUID=1L;

  private String mi;

  @TableField("onlineDays")
  private Long onlineDays;

  private Long month;

  @TableField("onlineMark")
  private String onlineMark;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  @TableField("sellerTaxCode")
  private String sellerTaxCode;

  @TableField("sellerName")
  private String sellerName;

  @TableField("invoicingMachineNo")
  private String invoicingMachineNo;

  @TableField("monthReportFile")
  private String monthReportFile;

  @TableField("deviceNo")
  private String deviceNo;

  @TableField("taxDiskType")
  private String taxDiskType;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("mi", mi);
      map.put("onlineDays", onlineDays);
      map.put("month", month);
      map.put("onlineMark", onlineMark);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("sellerTaxCode", sellerTaxCode);
      map.put("sellerName", sellerName);
      map.put("invoicingMachineNo", invoicingMachineNo);
      map.put("monthReportFile", monthReportFile);
      map.put("deviceNo", deviceNo);
      map.put("taxDiskType", taxDiskType);
      return map;
  }

  public static TaxDiskUsageStatistics fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    TaxDiskUsageStatistics entity = new TaxDiskUsageStatistics();
    if(map.containsKey("mi")) {
      Object obj = map.get("mi");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMi((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("onlineDays")) {
      Object obj = map.get("onlineDays");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOnlineDays((Long)obj);
        } else if(obj instanceof String) {
          entity.setOnlineDays(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setOnlineDays(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("month")) {
      Object obj = map.get("month");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMonth((Long)obj);
        } else if(obj instanceof String) {
          entity.setMonth(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setMonth(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("onlineMark")) {
      Object obj = map.get("onlineMark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOnlineMark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxCode")) {
      Object obj = map.get("sellerTaxCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicingMachineNo")) {
      Object obj = map.get("invoicingMachineNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoicingMachineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("monthReportFile")) {
      Object obj = map.get("monthReportFile");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMonthReportFile((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deviceNo")) {
      Object obj = map.get("deviceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeviceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxDiskType")) {
      Object obj = map.get("taxDiskType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxDiskType((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
