package com.xforceplus.taxwarebananaservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.taxwarebananaservice.entity.InvoiceMiMonitor;
import com.xforceplus.taxwarebananaservice.service.IInvoiceMiMonitorService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-06-27
 */
@RestController
public class InvoiceMiMonitorController {

  @Autowired
  private IInvoiceMiMonitorService invoiceMiMonitorServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceMiMonitor ${table.comment}
   * @return
   */
  @GetMapping("/invoicemimonitors" )
  public XfR getInvoiceMiMonitors(XfPage page, InvoiceMiMonitor invoiceMiMonitor) {
    return XfR.ok(invoiceMiMonitorServiceImpl.page(page, Wrappers.query(invoiceMiMonitor)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicemimonitors/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceMiMonitorServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceMiMonitor ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicemimonitors")
  public XfR save(@RequestBody InvoiceMiMonitor invoiceMiMonitor) {
     return XfR.ok(invoiceMiMonitorServiceImpl.save(invoiceMiMonitor));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceMiMonitor ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicemimonitors/{id}")
  public XfR putUpdate(@RequestBody InvoiceMiMonitor invoiceMiMonitor,@PathVariable Long id) {
      invoiceMiMonitor.setId(id);
      return XfR.ok(invoiceMiMonitorServiceImpl.updateById(invoiceMiMonitor));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceMiMonitor ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicemimonitors/{id}")
  public XfR patchUpdate(@RequestBody InvoiceMiMonitor invoiceMiMonitor,@PathVariable Long id) {
      InvoiceMiMonitor upinvoiceMiMonitor = invoiceMiMonitorServiceImpl.getById(id);
      if(upinvoiceMiMonitor != null){
        upinvoiceMiMonitor = ObjectCopyUtils.copyProperties(invoiceMiMonitor,upinvoiceMiMonitor,true);
      }
      return XfR.ok(invoiceMiMonitorServiceImpl.updateById(upinvoiceMiMonitor));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicemimonitors/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceMiMonitorServiceImpl.removeById(id));
  }

  @PostMapping("/invoicemimonitors/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_mi_monitor");
     params.put("request", condition);

     return XfR.ok(invoiceMiMonitorServiceImpl.querys(params));
  }

}
