package com.xforceplus.taxwarebananaservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.taxwarebananaservice.entity.InvoiceSerial;
import com.xforceplus.taxwarebananaservice.service.IInvoiceSerialService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-06-27
 */
@RestController
public class InvoiceSerialController {

  @Autowired
  private IInvoiceSerialService invoiceSerialServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceSerial ${table.comment}
   * @return
   */
  @GetMapping("/invoiceserials" )
  public XfR getInvoiceSerials(XfPage page, InvoiceSerial invoiceSerial) {
    return XfR.ok(invoiceSerialServiceImpl.page(page, Wrappers.query(invoiceSerial)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoiceserials/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceSerialServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceSerial ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoiceserials")
  public XfR save(@RequestBody InvoiceSerial invoiceSerial) {
     return XfR.ok(invoiceSerialServiceImpl.save(invoiceSerial));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceSerial ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoiceserials/{id}")
  public XfR putUpdate(@RequestBody InvoiceSerial invoiceSerial,@PathVariable Long id) {
      invoiceSerial.setId(id);
      return XfR.ok(invoiceSerialServiceImpl.updateById(invoiceSerial));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceSerial ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoiceserials/{id}")
  public XfR patchUpdate(@RequestBody InvoiceSerial invoiceSerial,@PathVariable Long id) {
      InvoiceSerial upinvoiceSerial = invoiceSerialServiceImpl.getById(id);
      if(upinvoiceSerial != null){
        upinvoiceSerial = ObjectCopyUtils.copyProperties(invoiceSerial,upinvoiceSerial,true);
      }
      return XfR.ok(invoiceSerialServiceImpl.updateById(upinvoiceSerial));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoiceserials/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceSerialServiceImpl.removeById(id));
  }

  @PostMapping("/invoiceserials/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_serial");
     params.put("request", condition);

     return XfR.ok(invoiceSerialServiceImpl.querys(params));
  }

}
