package com.xforceplus.taxwarebananaservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.taxwarebananaservice.entity.TaxDevice;
import com.xforceplus.taxwarebananaservice.service.ITaxDeviceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-06-28
 */
@RestController
public class TaxDeviceController {

  @Autowired
  private ITaxDeviceService taxDeviceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param taxDevice ${table.comment}
   * @return
   */
  @GetMapping("/taxdevices" )
  public XfR getTaxDevices(XfPage page, TaxDevice taxDevice) {
    return XfR.ok(taxDeviceServiceImpl.page(page, Wrappers.query(taxDevice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/taxdevices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(taxDeviceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param taxDevice ${table.comment}
   * @return XfR
   */
  @PostMapping("/taxdevices")
  public XfR save(@RequestBody TaxDevice taxDevice) {
     return XfR.ok(taxDeviceServiceImpl.save(taxDevice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param taxDevice ${table.comment}
   * @return XfR
   */
  @PutMapping("/taxdevices/{id}")
  public XfR putUpdate(@RequestBody TaxDevice taxDevice,@PathVariable Long id) {
      taxDevice.setId(id);
      return XfR.ok(taxDeviceServiceImpl.updateById(taxDevice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param taxDevice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/taxdevices/{id}")
  public XfR patchUpdate(@RequestBody TaxDevice taxDevice,@PathVariable Long id) {
      TaxDevice uptaxDevice = taxDeviceServiceImpl.getById(id);
      if(uptaxDevice != null){
        uptaxDevice = ObjectCopyUtils.copyProperties(taxDevice,uptaxDevice,true);
      }
      return XfR.ok(taxDeviceServiceImpl.updateById(uptaxDevice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/taxdevices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(taxDeviceServiceImpl.removeById(id));
  }

  @PostMapping("/taxdevices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tax_device");
     params.put("request", condition);

     return XfR.ok(taxDeviceServiceImpl.querys(params));
  }

}
