package com.xforceplus.taxwarebananaservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.taxwarebananaservice.entity.ClientUpdate;
import com.xforceplus.taxwarebananaservice.service.IClientUpdateService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-14
 */
@RestController
public class ClientUpdateController {

  @Autowired
  private IClientUpdateService clientUpdateServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param clientUpdate ${table.comment}
   * @return
   */
  @GetMapping("/clientupdates" )
  public XfR getClientUpdates(XfPage page, ClientUpdate clientUpdate) {
    return XfR.ok(clientUpdateServiceImpl.page(page, Wrappers.query(clientUpdate)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/clientupdates/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(clientUpdateServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param clientUpdate ${table.comment}
   * @return XfR
   */
  @PostMapping("/clientupdates")
  public XfR save(@RequestBody ClientUpdate clientUpdate) {
     return XfR.ok(clientUpdateServiceImpl.save(clientUpdate));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param clientUpdate ${table.comment}
   * @return XfR
   */
  @PutMapping("/clientupdates/{id}")
  public XfR putUpdate(@RequestBody ClientUpdate clientUpdate,@PathVariable Long id) {
      clientUpdate.setId(id);
      return XfR.ok(clientUpdateServiceImpl.updateById(clientUpdate));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param clientUpdate ${table.comment}
   * @return XfR
   */
  @PatchMapping("/clientupdates/{id}")
  public XfR patchUpdate(@RequestBody ClientUpdate clientUpdate,@PathVariable Long id) {
      ClientUpdate upclientUpdate = clientUpdateServiceImpl.getById(id);
      if(upclientUpdate != null){
        upclientUpdate = ObjectCopyUtils.copyProperties(clientUpdate,upclientUpdate,true);
      }
      return XfR.ok(clientUpdateServiceImpl.updateById(upclientUpdate));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/clientupdates/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(clientUpdateServiceImpl.removeById(id));
  }

  @PostMapping("/clientupdates/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "client_update");
     params.put("request", condition);

     return XfR.ok(clientUpdateServiceImpl.querys(params));
  }

}
