package com.xforceplus.taxwarebananaservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.taxwarebananaservice.entity.TaxDiskUsageStatistics;
import com.xforceplus.taxwarebananaservice.service.ITaxDiskUsageStatisticsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-14
 */
@RestController
public class TaxDiskUsageStatisticsController {

  @Autowired
  private ITaxDiskUsageStatisticsService taxDiskUsageStatisticsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param taxDiskUsageStatistics ${table.comment}
   * @return
   */
  @GetMapping("/taxdiskusagestatisticss" )
  public XfR getTaxDiskUsageStatisticss(XfPage page, TaxDiskUsageStatistics taxDiskUsageStatistics) {
    return XfR.ok(taxDiskUsageStatisticsServiceImpl.page(page, Wrappers.query(taxDiskUsageStatistics)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/taxdiskusagestatisticss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(taxDiskUsageStatisticsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param taxDiskUsageStatistics ${table.comment}
   * @return XfR
   */
  @PostMapping("/taxdiskusagestatisticss")
  public XfR save(@RequestBody TaxDiskUsageStatistics taxDiskUsageStatistics) {
     return XfR.ok(taxDiskUsageStatisticsServiceImpl.save(taxDiskUsageStatistics));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param taxDiskUsageStatistics ${table.comment}
   * @return XfR
   */
  @PutMapping("/taxdiskusagestatisticss/{id}")
  public XfR putUpdate(@RequestBody TaxDiskUsageStatistics taxDiskUsageStatistics,@PathVariable Long id) {
      taxDiskUsageStatistics.setId(id);
      return XfR.ok(taxDiskUsageStatisticsServiceImpl.updateById(taxDiskUsageStatistics));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param taxDiskUsageStatistics ${table.comment}
   * @return XfR
   */
  @PatchMapping("/taxdiskusagestatisticss/{id}")
  public XfR patchUpdate(@RequestBody TaxDiskUsageStatistics taxDiskUsageStatistics,@PathVariable Long id) {
      TaxDiskUsageStatistics uptaxDiskUsageStatistics = taxDiskUsageStatisticsServiceImpl.getById(id);
      if(uptaxDiskUsageStatistics != null){
        uptaxDiskUsageStatistics = ObjectCopyUtils.copyProperties(taxDiskUsageStatistics,uptaxDiskUsageStatistics,true);
      }
      return XfR.ok(taxDiskUsageStatisticsServiceImpl.updateById(uptaxDiskUsageStatistics));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/taxdiskusagestatisticss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(taxDiskUsageStatisticsServiceImpl.removeById(id));
  }

  @PostMapping("/taxdiskusagestatisticss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tax_disk_usage_statistics");
     params.put("request", condition);

     return XfR.ok(taxDiskUsageStatisticsServiceImpl.querys(params));
  }

}
