package com.xforceplus.taxwaregranadaservice.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2023-01-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.taxwaregranadaservice.entity.ConstructionServices;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "taxware-granada-service")
public interface ConstructionServicesFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/constructionServices/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param constructionServices ${table.comment}
   * @return R
   */
  @PostMapping("/constructionServices/add")
  public R save(@RequestBody ConstructionServices constructionServices);

  /**
   * 修改${table.comment}
   * @param constructionServices ${table.comment}
   * @return R
   */
  @PostMapping("/constructionServices/update")
  public R updateById(@RequestBody ConstructionServices constructionServices);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/constructionServices/del/{id}" )
  public R removeById(@PathVariable Long id);

}