package com.xforceplus.taxwaregranadaservice.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2023-01-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.taxwaregranadaservice.entity.Freightage;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "taxware-granada-service")
public interface FreightageFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/freightage/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param freightage ${table.comment}
   * @return R
   */
  @PostMapping("/freightage/add")
  public R save(@RequestBody Freightage freightage);

  /**
   * 修改${table.comment}
   * @param freightage ${table.comment}
   * @return R
   */
  @PostMapping("/freightage/update")
  public R updateById(@RequestBody Freightage freightage);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/freightage/del/{id}" )
  public R removeById(@PathVariable Long id);

}