package com.xforceplus.tech.logger.domain;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import net.logstash.logback.util.StringUtils;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * custom serializer
 */
public class LoggerRecorderSerializer extends StdSerializer<LogRecord> {

    public LoggerRecorderSerializer() {
        this(null);
    }

    protected LoggerRecorderSerializer(Class<LogRecord> t) {
        super(t);
    }

    @Override
    public void serialize(LogRecord loggerRecord, JsonGenerator jgen, SerializerProvider serializerProvider) throws IOException {
        jgen.writeStartObject();
        if (loggerRecord.getElapsedTime() > 0) {
            TimeUnit timeUnit = loggerRecord.getTimeUnit();
            long convert = timeUnit.convert(loggerRecord.getElapsedTime(), TimeUnit.NANOSECONDS);
            jgen.writeNumberField("elapsedTime_".concat(timeUnit.name().toLowerCase()), convert);
        }

        if (!StringUtils.isEmpty(loggerRecord.getType())) {
            jgen.writeStringField("type", loggerRecord.getType());
        }

        if (!StringUtils.isEmpty(loggerRecord.getName())) {
            jgen.writeStringField("name", loggerRecord.getName());
        }

        if (!StringUtils.isEmpty(loggerRecord.getKey())) {
            jgen.writeStringField("key", loggerRecord.getKey());
        }

        if (!StringUtils.isEmpty(loggerRecord.getSubType())) {
            jgen.writeStringField("subType", loggerRecord.getSubType());
        }

        if (!StringUtils.isEmpty(loggerRecord.getStatus())) {
            jgen.writeStringField("status", loggerRecord.getStatus());
        }
        Map<String, Object> params = loggerRecord.getParams();
        if (params != null) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                jgen.writeObjectField("params.".concat(entry.getKey()), entry.getValue());
            }
        }

        Map<String, Object> ext = loggerRecord.getExt();
        if(ext != null) {
            for (Map.Entry<String, Object> entry : ext.entrySet()) {
                jgen.writeObjectField("ext.".concat(entry.getKey()), entry.getValue());
            }
        }

        jgen.writeEndObject();
    }
}
