package com.xforceplus.tenantsecurity.interceptor;


import com.xforceplus.tenantsecurity.domain.IAuthorizedUser;
import com.xforceplus.tenantsecurity.domain.UserInfoHolder;
import com.xforceplus.tenantsecurity.domain.UserType;
import com.xforceplus.tenantsecurity.utils.CompressionUtils;
import com.xforceplus.tenantsecurity.utils.JsonUtils;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * 微服务中拦截调用微服务请求，把上下文设置到header中
 * JDK 版本:      1.8
 * @author        geewit
 * @since         2019-05-13
 */
public class MicroServiceFeignInterceptor implements RequestInterceptor {

    private static final Logger logger = LoggerFactory.getLogger(MicroServiceFeignInterceptor.class);


    /**
     * @param requestTemplate
     */
    @Override
    public void apply(RequestTemplate requestTemplate) {
        IAuthorizedUser userInfo = UserInfoHolder.get();
        if (userInfo != null) {
            try {
                String value = CompressionUtils.encode(JsonUtils.toJson(userInfo));
                requestTemplate.header(UserType.USER.userinfoKey(), value);
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        }
    }
}
