package com.xforceplus.tenantsecurity.selectors;

import com.xforceplus.tenantsecurity.interceptor.MicroServiceFeignInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;

/**
 * 用于微服务中启用相关类
 * @author        geewit
 * @since         2019-05-13
 */
public class FeignInterceptorImportSelector implements ImportSelector {

    private Logger logger = LoggerFactory.getLogger(FeignInterceptorImportSelector.class);

    /**
     * Select and return the names of which class(es) should be imported based on
     * the {@link AnnotationMetadata} of the importing @Configuration class.
     *
     * @param importingClassMetadata
     */
    @Override
    public String[] selectImports(AnnotationMetadata importingClassMetadata) {
        logger.info("--------启用用户下文--------");
        return new String[]{
                MicroServiceFeignInterceptor.class.getName()
        };
    }
}
