package com.xforcecloud.excel.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xforceplus.tenantsecurity.domain.AuthorizationInfo;
import com.xforceplus.tenantsecurity.domain.AuthorizationUri;
import com.xforceplus.tenantsecurity.utils.JsonUtils;
import org.apache.commons.io.FileUtils;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ResourceUtils;

import javax.annotation.PostConstruct;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;

@Service
public class Json2ExcelService {

    @Value("${json_path:classpath:demo.json}")
    private String jsonPath;

    @Value("${excel_path:classpath:demo.excel}")
    private String excelPath;


    @PostConstruct
    public void process() {
        try {
            String json = FileUtils.readFileToString(ResourceUtils.getFile(jsonPath), StandardCharsets.UTF_8);
            Map<String, AuthorizationInfo> map = JsonUtils.fromJson(json, new TypeReference<Map<String, AuthorizationInfo>>() {
            });
            XSSFWorkbook wb = new XSSFWorkbook();
            XSSFSheet sheet = wb.createSheet("a");
            int i = 0;
            for(Map.Entry<String, AuthorizationInfo> entry : map.entrySet()) {
                String key = entry.getKey();
                AuthorizationInfo authorizationInfo = entry.getValue();
                AuthorizationUri authorizationUri = AuthorizationUri.parse(key);
                XSSFRow row = sheet.createRow(i);
                int j = 0;
                XSSFCell cell = row.createCell(j, CellType.STRING);
                cell.setCellValue(authorizationUri.getPath());
                j++;
                cell = row.createCell(j, CellType.STRING);
                cell.setCellValue(authorizationUri.getMethod().name());
                j++;
                cell = row.createCell(j, CellType.STRING);
                cell.setCellValue(authorizationInfo.getName());
                i++;
            }
            FileOutputStream outputStream = new FileOutputStream("D:\\demo.xlsx");
            wb.write(outputStream);
            outputStream.close();
        } catch (IOException e) {
            // TODO 自动生成的 catch 块
            e.printStackTrace();
        }
    }
}
