package com.xforceplus.tenantsecurity.feign.client;

import com.xforceplus.tenantsecurity.domain.UserType;
import feign.Client;
import feign.Feign;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.cloud.openfeign.support.SpringMvcContract;
import org.springframework.stereotype.Service;

@Service
public class UserExtraInfoClientService {
    @Autowired
    @Qualifier("tenantClient")
    private Client client;

    @Value("${tenant.gateway.user-center.url}")
    private String url;

    @Autowired
    private SpringEncoder encoder;

    @Autowired
    private SpringDecoder decoder;

    public UserExtraInfoClient userExtraInfoClient(String token) {
        UserExtraInfoClient userExtraInfoClient = Feign.builder().client(client)
                .contract(new SpringMvcContract())
                .encoder(encoder)
                .decoder(decoder)
                .requestInterceptor(template -> template.header(UserType.USER.tokenKey(), token))
                .target(UserExtraInfoClient.class, url);
        return userExtraInfoClient;
    }

}
