/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenantsecurity.interceptor;

import com.auth0.jwt.exceptions.TokenExpiredException;
import com.google.common.collect.Lists;
import com.xforceplus.tenantsecurity.annotation.Authorization;
import com.xforceplus.tenantsecurity.annotation.NeedExtraInfo;
import com.xforceplus.tenantsecurity.annotation.WithoutAuth;
import com.xforceplus.tenantsecurity.config.AuthorityProperties;
import com.xforceplus.tenantsecurity.domain.AuthorizedUser;
import com.xforceplus.tenantsecurity.domain.IAuthorizedUser;
import com.xforceplus.tenantsecurity.domain.UserInfoHolder;
import com.xforceplus.tenantsecurity.domain.UserType;
import com.xforceplus.tenantsecurity.feign.client.UserExtraInfoClientService;
import com.xforceplus.tenantsecurity.feign.client.UserResourceClientService;
import com.xforceplus.tenantsecurity.feign.model.ExtraInfoModel;
import com.xforceplus.tenantsecurity.feign.model.MsCheckExistsResourceRequest;
import com.xforceplus.tenantsecurity.feign.model.MsCheckExistsResourceResponse;
import com.xforceplus.tenantsecurity.feign.model.MsGetUserExtraInfoRequest;
import com.xforceplus.tenantsecurity.feign.model.MsGetUserExtraInfoResponse;
import com.xforceplus.tenantsecurity.jwt.JwtUtils;
import com.xforceplus.tenantsecurity.utils.CompressionUtils;
import com.xforceplus.tenantsecurity.utils.JsonUtils;
import com.xforceplus.tenantsecurity.utils.RequestUrlUtils;
import com.xforceplus.tenantsecurity.utils.RequestUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.WebUtils;

public class UserContextInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(UserContextInterceptor.class);
    @Autowired
    private Environment environment;
    @Autowired(required=false)
    private AuthorityProperties authorityProperties;
    @Value(value="${xforce.tenant_security.adapter.interceptors.default_user_info:}")
    private String defaultUserInfoJson;
    @Value(value="${tenant.security.jwt.secret:my_sessionjw_tsecret_xdfdffdsdfdfs}")
    private String secret;
    @Autowired
    private UserExtraInfoClientService userExtraInfoClientService;
    @Autowired
    private UserResourceClientService userResourceClientService;
    @Value(value="${xforce.tenant_security.appid:}")
    private String appid;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        Long tenantId;
        String tenantIdStr;
        String token;
        if (handler instanceof ResourceHttpRequestHandler) {
            return true;
        }
        boolean isStaticPage = RequestUrlUtils.isStaticPage((String)request.getRequestURI());
        if (isStaticPage) {
            return true;
        }
        HandlerMethod method = (HandlerMethod)handler;
        boolean isWithoutAuth = method.hasMethodAnnotation(WithoutAuth.class);
        if (isWithoutAuth) {
            if (StringUtils.isNotEmpty((CharSequence)this.defaultUserInfoJson)) {
                this.setUserInfoHolder(this.defaultUserInfoJson);
            }
            return true;
        }
        Cookie tokenCookie = WebUtils.getCookie((HttpServletRequest)request, (String)UserType.USER.tokenKey());
        if (tokenCookie != null) {
            token = tokenCookie.getValue();
        } else {
            logger.warn("Cookie\u4e2d\u65e0token");
            token = request.getHeader(UserType.USER.tokenKey());
            if (StringUtils.isEmpty((CharSequence)token)) {
                logger.warn("Header\u4e2d\u65e0token");
                token = WebUtils.findParameterValue((ServletRequest)request, (String)UserType.USER.tokenKey());
            }
        }
        if (StringUtils.isBlank((CharSequence)token)) {
            String message = "\u8bbf\u95ee\u5931\u8d25\uff0c\u6ca1\u6709\u767b\u5f55";
            logger.warn("token isBlank, " + message);
        }
        Map claims = null;
        if (StringUtils.isNotBlank((CharSequence)token)) {
            try {
                claims = JwtUtils.verifyAndDecodeToken((String)this.secret, (String)token);
            }
            catch (TokenExpiredException e) {
                logger.error("token\u8fc7\u671f\u5f02\u5e38TokenExpiredException,token=={}", (Object)token);
                String message = "token\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55";
                this.responseUnauthorized(message, request, response);
                return false;
            }
            catch (Exception e) {
                String message = "token\u89e3\u6790\u5931\u8d25\u3002";
                logger.error(message + ",token==" + token, (Throwable)e);
                this.responseUnauthorized(message, request, response);
                return false;
            }
        }
        if (claims == null) {
            String message = "\u8bbf\u95ee\u5931\u8d25\uff0c\u6ca1\u6709\u767b\u5f55";
            logger.warn("claims == null, " + message);
            this.responseUnauthorized(message, request, response);
            return false;
        }
        String systemType = (String)claims.get("type");
        if (!UserType.USER.value().equals(systemType)) {
            String message = "token\u975e\u6cd5\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55";
            logger.warn("claims == null, " + message);
            this.responseUnauthorized(message, request, response);
            return false;
        }
        String encodedUserInfo = (String)claims.get("userinfo");
        if (StringUtils.isBlank((CharSequence)encodedUserInfo)) {
            String message = "\u8bbf\u95ee\u5931\u8d25\uff0c\u65e0\u6548\u4ee4\u724c";
            logger.warn("userinfo isBlank, " + message);
            this.responseUnauthorized(message, request, response);
            return false;
        }
        String userinfo = CompressionUtils.decode((String)encodedUserInfo);
        if (StringUtils.isBlank((CharSequence)userinfo)) {
            String message = "\u8bbf\u95ee\u5931\u8d25\uff0c\u65e0\u6548\u4ee4\u724c";
            logger.warn("userinfo == null, " + message);
            this.responseUnauthorized(message, request, response);
            return false;
        }
        Authorization authorization = (Authorization)method.getMethodAnnotation(Authorization.class);
        if (authorization != null) {
            String checkStr;
            String[] resourceCodes = authorization.value();
            try {
                checkStr = this.checkResourceCode(token, resourceCodes);
            }
            catch (Exception e) {
                String message = "\u8d44\u6e90\u7801\u6821\u9a8c\u53d1\u751f\u5f02\u5e38";
                logger.error(message, (Throwable)e);
                this.responseUnauthorized(message, request, response);
                return false;
            }
            logger.info("\u8d44\u6e90\u7801\u6821\u9a8c\u7ed3\u679c,msg = {}", (Object)checkStr);
            if (StringUtils.isNotBlank((CharSequence)checkStr)) {
                logger.warn("\u8d44\u6e90\u7801\u6821\u9a8c\u6ca1\u6709\u901a\u8fc7, msg = {}", (Object)checkStr);
                this.responseUnauthorized(checkStr, request, response);
                return false;
            }
        }
        if ((tenantIdStr = request.getHeader("tenantId")) == null) {
            Map pathVariables = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
            tenantIdStr = (String)pathVariables.get("tenantId");
        }
        try {
            tenantId = Long.parseLong(tenantIdStr);
        }
        catch (NumberFormatException e) {
            logger.warn(e.getMessage() + ", tenantId = " + tenantIdStr);
            tenantId = null;
        }
        try {
            return this.setUserInfoHolder(userinfo, token, tenantId, method);
        }
        catch (Exception e) {
            String message = "\u89e3\u6790\u7528\u6237\u4e0a\u4e0b\u6587\u53d1\u751f\u5f02\u5e38";
            logger.error(message, (Throwable)e);
            this.responseUnauthorized(message, request, response);
            return false;
        }
    }

    private String checkResourceCode(String token, String[] resourceCodes) {
        if (resourceCodes == null || resourceCodes.length == 0) {
            return null;
        }
        MsCheckExistsResourceRequest msCheckExistsResourceRequest = new MsCheckExistsResourceRequest();
        msCheckExistsResourceRequest.setAppId(Integer.valueOf(this.appid));
        msCheckExistsResourceRequest.setResourceCodes((List)Lists.newArrayList((Object[])resourceCodes));
        MsCheckExistsResourceResponse msCheckExistsResourceResponse = this.userResourceClientService.userExtraInfoClient(token).checkExistsResource(msCheckExistsResourceRequest);
        if (msCheckExistsResourceResponse.getCode() != 1) {
            String message = "\u8d44\u6e90\u7801\u6821\u9a8c\u5931\u8d25";
            if (StringUtils.isBlank((CharSequence)msCheckExistsResourceResponse.getMessage())) {
                message = msCheckExistsResourceResponse.getMessage();
            }
            return message;
        }
        if (!msCheckExistsResourceResponse.getCheck().booleanValue()) {
            return "\u8d44\u6e90\u7801\u6821\u9a8c\u6ca1\u901a\u8fc7";
        }
        return null;
    }

    private void setUserInfoHolder(String userinfo) {
        IAuthorizedUser userInfo = (IAuthorizedUser)JsonUtils.fromJson((String)userinfo, AuthorizedUser.class);
        UserInfoHolder.put((IAuthorizedUser)userInfo);
    }

    private boolean setUserInfoHolder(String userinfo, String token, Long tenantId, HandlerMethod method) {
        AuthorizedUser userInfo = (AuthorizedUser)JsonUtils.fromJson((String)userinfo, AuthorizedUser.class);
        if (userInfo == null) {
            logger.warn("userinfo = " + userinfo);
            return false;
        }
        if (tenantId != null) {
            userInfo.setTenantId(tenantId.longValue());
        }
        UserInfoHolder.put((IAuthorizedUser)userInfo);
        NeedExtraInfo needExtraInfo = (NeedExtraInfo)method.getMethodAnnotation(NeedExtraInfo.class);
        if (needExtraInfo != null && (needExtraInfo.resources() || needExtraInfo.orgs() || needExtraInfo.companies() || needExtraInfo.currentOrgs() || needExtraInfo.parentCompanies())) {
            MsGetUserExtraInfoRequest msGetUserExtraInfoRequest = new MsGetUserExtraInfoRequest();
            try {
                int appId = Integer.parseInt(this.appid);
                msGetUserExtraInfoRequest.setAppId(appId);
            }
            catch (NumberFormatException e) {
                logger.warn("\u4e3a\u8bbe\u7f6eappid");
                return false;
            }
            msGetUserExtraInfoRequest.setResources(needExtraInfo.resources());
            msGetUserExtraInfoRequest.setOrgs(needExtraInfo.orgs());
            msGetUserExtraInfoRequest.setParentCompanies(needExtraInfo.parentCompanies());
            msGetUserExtraInfoRequest.setCurrentOrgs(needExtraInfo.currentOrgs());
            msGetUserExtraInfoRequest.setCompanies(needExtraInfo.companies());
            MsGetUserExtraInfoResponse msGetUserExtraInfoResponse = this.userExtraInfoClientService.userExtraInfoClient(token).extraInfo(msGetUserExtraInfoRequest);
            ExtraInfoModel extraInfoModel = (ExtraInfoModel)JsonUtils.fromJson((String)msGetUserExtraInfoResponse.getInfoJson(), ExtraInfoModel.class);
            userInfo.setResourceCodes(extraInfoModel.getResourceCodes());
            userInfo.setOrgs(extraInfoModel.getOrgs());
            userInfo.setParentCompanies(extraInfoModel.getParentCompanies());
            userInfo.setCurrentOrgs(extraInfoModel.getCurrentOrgs());
            userInfo.setCompanies(extraInfoModel.getCompanies());
        }
        userInfo.setToken(token);
        UserInfoHolder.put((IAuthorizedUser)userInfo);
        return true;
    }

    private void responseUnauthorized(String message, HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean isAjaxRequest = RequestUtils.isAjaxRequest((HttpServletRequest)request);
        String loginUrl = this.environment.getProperty("tenant.security.authority.login_url", this.authorityProperties.getLoginUrl());
        UriComponents uriComponents = UriComponentsBuilder.fromUriString((String)loginUrl).build();
        String loginURI = uriComponents.toUriString();
        if (isAjaxRequest) {
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            response.setContentType("application/json;charset=UTF-8");
            response.setStatus(401);
            LinkedHashMap<String, String> error = new LinkedHashMap<String, String>();
            error.put("code", "0");
            error.put("message", message);
            error.put("loginUrl", loginURI);
            response.getWriter().write(JsonUtils.toJson(error));
        } else {
            response.sendRedirect(loginURI);
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        UserInfoHolder.clearContext();
    }
}

