package com.xforceplus.tenantsecurity.config;

import com.netflix.loadbalancer.ILoadBalancer;
import feign.Client;
import feign.okhttp.OkHttpClient;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.loadbalancer.LoadBalancerAutoConfiguration;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.openfeign.ribbon.CachingSpringLoadBalancerFactory;
import org.springframework.cloud.openfeign.ribbon.LoadBalancerFeignClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;


@Configuration
@ConditionalOnClass({ILoadBalancer.class})
@AutoConfigureBefore({LoadBalancerAutoConfiguration.class})
@AutoConfigureAfter({TenantFeignOkHttpConfig.class})
public class LoadBalancerFeignConfig {

    @Primary
    @Bean
    @ConditionalOnMissingBean(LoadBalancerFeignClient.class)
    public Client feignClient(CachingSpringLoadBalancerFactory cachingFactory,
                              SpringClientFactory clientFactory, OkHttpClient okHttpClient) {
        return new LoadBalancerFeignClient(okHttpClient, cachingFactory, clientFactory);
    }


}
