package com.xforceplus.tenantsecurity.config;

import com.xforceplus.tenantsecurity.interceptor.UserContextInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * 自动配置spring mvc的拦截器
 * @author:      黄方
 * @since:       2019/05/13
 */
@Configuration
@ConditionalOnExpression("${xforce.tenant_security.starter.interceptors.enable:true}")
public class WebMvcInterceptorConfig implements WebMvcConfigurer {


    @Autowired
    private UserContextInterceptor userContextInterceptor;

    @Bean
    public UserContextInterceptor userContextInterceptor() {
        return new UserContextInterceptor();
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(userContextInterceptor);
    }
}
