/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenantsecurity.feign.client;

import com.xforceplus.tenantsecurity.domain.UserType;
import com.xforceplus.tenantsecurity.feign.client.UserExtraInfoClient;
import feign.Client;
import feign.Contract;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.cloud.openfeign.support.SpringMvcContract;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class UserExtraInfoClientService {
    @Autowired
    @Qualifier(value="tenantClient")
    private Client client;
    @Autowired
    private Environment environment;
    @Autowired
    private SpringEncoder encoder;
    @Autowired
    private SpringDecoder decoder;

    public UserExtraInfoClient userExtraInfoClient(String userinfo) {
        String url = this.environment.getProperty("tenant.gateway.user-center.url", "http://user-center-app:8080");
        UserExtraInfoClient userExtraInfoClient = (UserExtraInfoClient)Feign.builder().client(this.client).contract((Contract)new SpringMvcContract()).encoder((Encoder)this.encoder).decoder((Decoder)this.decoder).requestInterceptor(template -> template.header(UserType.USER.userinfoKey(), new String[]{userinfo})).target(UserExtraInfoClient.class, url);
        return userExtraInfoClient;
    }
}

