package com.xforceplus.tenantsecurity.config;

import com.xforceplus.tenantsecurity.interceptor.OperatorContextInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * 项目名称:
 * 模块名称:
 * 说明:
 * JDK 版本:      1.8
 * 作者(@author): chen cheng
 * 创建日期:      2018/10/22 17:22
 */
@ConditionalOnExpression("${xforce.tenant_security.interceptors.enable:true}")
@Configuration
public class WebMvcInterceptorConfig implements WebMvcConfigurer {

    @Autowired
    private OperatorContextInterceptor operatorContextInterceptor;

    @Bean
    public OperatorContextInterceptor userContextInterceptor() {
        return new OperatorContextInterceptor();
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(operatorContextInterceptor);
    }
}
