package com.xforceplus.tenantsecurity.interceptor;

import com.xforceplus.tenantsecurity.domain.AuthorizedOperator;
import com.xforceplus.tenantsecurity.domain.IAuthorizedOperator;
import com.xforceplus.tenantsecurity.domain.OperatorInfoHolder;
import com.xforceplus.tenantsecurity.domain.UserType;
import com.xforceplus.tenantsecurity.utils.CompressionUtils;
import com.xforceplus.tenantsecurity.utils.JsonUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 项目名称:
 * 模块名称:
 * 说明:          微服务中 拦截http请求，解析请求头中的用户信息
 * JDK 版本:      1.8
 * 作者(@author): chen cheng
 * 创建日期:      2018/10/22 15:55
 */
public class OperatorContextInterceptor implements HandlerInterceptor {

    private static final Logger logger = LoggerFactory.getLogger(OperatorContextInterceptor.class);


    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String user = request.getHeader(UserType.STAFF.userinfoKey());
        if (StringUtils.isEmpty(user)) {
            return true;
        }
        try {
            user = CompressionUtils.decode(user);
            IAuthorizedOperator userInfo = JsonUtils.fromJson(user, AuthorizedOperator.class);
            OperatorInfoHolder.put(userInfo);
        } catch (Exception e) {
            logger.error("解析用户上下文发生异常", e);
        }
        return true;
    }

//    public static void main(String[] args) {
//        String user = "{\n" +
//                "  \"id\": 363401612374016,\n" +
//                "  \"tenantId\": 1,\n" +
//                "  \"tenantName\": \"票易通（进项）集团\",\n" +
//                "  \"accountId\": 363401222303744,\n" +
//                "  \"username\": \"超级管理员\",\n" +
//                "  \"mobile\": \"18317166757\",\n" +
//                "  \"email\": \"18317166757\",\n" +
//                "  \"admin\": false,\n" +
//                "  \"companies\": [\n" +
//                "    \"002332344233\",\n" +
//                "    \"00932323323\"\n" +
//                "  ],\n" +
//                "  \"roles\": [\n" +
//                "    {\n" +
//                "      \"id\": 1,\n" +
//                "      \"tenantId\": 111,\n" +
//                "      \"name\": \"管理员1\"\n" +
//                "    },\n" +
//                "    {\n" +
//                "      \"id\": 2,\n" +
//                "      \"tenantId\": 111,\n" +
//                "      \"name\": \"管理员2\"\n" +
//                "    }\n" +
//                "  ]\n" +
//                "}";
//        user = Base64Utils.encodeToString(user.getBytes(StandardCharsets.UTF_8));
//        System.out.println(user);
//        user = new String(Base64Utils.decodeFromString(user), StandardCharsets.UTF_8);
//        System.out.println(user);
//    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        OperatorInfoHolder.clearContext();
    }
}
