package com.xforceplus.tenantsecurity.selectors;

import com.xforceplus.tenantsecurity.config.WebMvcInterceptorConfig;
import com.xforceplus.tenantsecurity.interceptor.OperatorContextInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;

/**
 * 项目名称:
 * 模块名称:
 * 说明:          用于微服务中启用相关类
 * JDK 版本:      1.8
 * 作者(@author): chen cheng
 * 创建日期:      2018/10/24 14:28
 */
public class MvcInterceptorImportSelector implements ImportSelector {

    private Logger logger = LoggerFactory.getLogger(MvcInterceptorImportSelector.class);

    /**
     * Select and return the names of which class(es) should be imported based on
     * the {@link AnnotationMetadata} of the importing @Configuration class.
     *
     * @param importingClassMetadata
     */
    @Override
    public String[] selectImports(AnnotationMetadata importingClassMetadata) {
        logger.info("--------启用用户下文--------");
        return new String[]{
                WebMvcInterceptorConfig.class.getName(),
                OperatorContextInterceptor.class.getName()
        };
    }
}
