/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenantsecurity.interceptor;

import com.xforceplus.tenantsecurity.domain.AuthorizedOperator;
import com.xforceplus.tenantsecurity.domain.IAuthorizedOperator;
import com.xforceplus.tenantsecurity.domain.OperatorInfoHolder;
import com.xforceplus.tenantsecurity.domain.UserType;
import com.xforceplus.tenantsecurity.utils.CompressionUtils;
import com.xforceplus.tenantsecurity.utils.JsonUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;

public class OperatorContextInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(OperatorContextInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String user = request.getHeader(UserType.STAFF.userinfoKey());
        if (StringUtils.isEmpty((CharSequence)user)) {
            return true;
        }
        try {
            user = CompressionUtils.decode((String)user);
            IAuthorizedOperator userInfo = (IAuthorizedOperator)JsonUtils.fromJson((String)user, AuthorizedOperator.class);
            OperatorInfoHolder.put((IAuthorizedOperator)userInfo);
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u7528\u6237\u4e0a\u4e0b\u6587\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        OperatorInfoHolder.clearContext();
    }
}

