package com.xforceplus.route.api.common.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.util.Collection;
import java.util.List;

/***
 * @author geewit
 */
@SuppressWarnings("all")
public interface ResourceModel {

    interface Request {
        @Setter
        @Getter
        @ApiModel("资源码查询参数")
        class Query {
            @ApiModelProperty("接口id")
            private Long serviceApiId;
            @ApiModelProperty("接口名称")
            private String serviceApiName;
            @ApiModelProperty("资源码id")
            private Long resourceId;
            @ApiModelProperty("appid")
            private Long appId;
            @ApiModelProperty("资源码")
            private String resourceCode;
            @ApiModelProperty("资源码模糊")
            private String resourceCodeLike;
            @ApiModelProperty("资源码名称")
            private String resourceName;
            @ApiModelProperty("上级资源码id")
            private Long parentId;
            @ApiModelProperty(value = "启用状态", notes = "1:启用, 0:注销")
            private Integer status;
            @ApiModelProperty(value = "是否属于公司服务包", notes = "1:是, 0:否")
            private Boolean isServicePackage;
            @ApiModelProperty("是否需要拉平的结果")
            private boolean isFlat = true;
            /**
             * 资源码ID数组
             */
            @ApiModelProperty("资源码ID数组")
            private Collection<Long> resourceIds;
        }

        @Setter
        @Getter
        @ApiModel("资源码批量绑定接口")
        class BindApis {
            @ApiModelProperty(value = "是否覆盖", notes = "是: 表示报文中的接口id集合中不包含的关系会被删除,包含的会新增, 否: 只新增报文中包含的关系", example = "false")
            boolean isOverwrite;
            @ApiModelProperty(value = "接口id集合")
            private List<Long> apiIds;
        }
    }

    interface Response {

    }
}
