package com.xforceplus.route.api.common.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;

/**
 * @author geewit
 */
public interface RouteModel {

    interface Request {
        @Setter
        @Getter
        class Query {
            private Long routeId;
            @ApiModelProperty("多个routeId")
            private String routeIds;
            private Long appId;
            private String routeName;
            private String path;
            private String url;
            private Integer status;
            private Boolean isStatic;
            private Boolean isExactMatch;
            private String groupType;
            private Boolean billable;
            private Boolean skipAuthentication;
            private Boolean skipAuthorization;
            private String contact;
            private String contactTeam;
        }
        
        @Setter
        @Getter
        class Save {
            @ApiModelProperty("appId")
            private Long appId;
            @ApiModelProperty("路由名称")
            private String routeName;
            @ApiModelProperty("路由地址")
            private String path;
            @ApiModelProperty("服务地址")
            private String url;
            @ApiModelProperty("是否静态")
            private Boolean isStatic;
            @ApiModelProperty("是否精确匹配")
            private Boolean isExactMatch;
            @ApiModelProperty("status")
            private Integer status;
            @ApiModelProperty("groupType")
            private String groupType;
            @ApiModelProperty("billable")
            private Boolean billable;
            @ApiModelProperty("是否跳过认证")
            private Boolean skipAuthentication;
            @ApiModelProperty("是否跳过鉴权")
            private Boolean skipAuthorization;
            private String hash;
            private Integer timeout;
            @ApiModelProperty("是否开启自动扫描")
            private Boolean enableAutoscan;
            @NotBlank(message = "联系人不能为空")
            @ApiModelProperty("联系人")
            private String contact;
            @NotBlank(message = "联系团队不能为空")
            @ApiModelProperty("联系人团队")
            private String contactTeam;
        }
    }
}
