package com.xforceplus.route.api.common.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.validator.constraints.Range;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/***
 * @author HuangFang
 */
public interface ServiceApiModel {
    interface Request {
        @Setter
        @Getter
        @ApiModel("服务Api查询参数")
        class Query {
            @ApiModelProperty(value = "租户id")
            private Long tenantId;
            @ApiModelProperty(value = "资源码id")
            private Long resourceId;
            @ApiModelProperty(value = "资源码code")
            private String resourceCode;
            @ApiModelProperty(value = "服务Api接口id")
            private Long serviceApiId;
            @ApiModelProperty(value = "服务Api接口类名路径")
            private String serviceApiPath;
            @ApiModelProperty(value = "请求url")
            private String serviceApiUrl;
            @ApiModelProperty(value = "Http请求方法")
            private RequestMethod requestMethod;
            @ApiModelProperty(value = "appid")
            private Long appId;
            @ApiModelProperty(value = "路由id")
            private Long routeId;
            @ApiModelProperty(value = "跳过鉴权", notes = "1:跳过, 0:不跳过")
            private Boolean skipAuth;
            @ApiModelProperty(value = "跳过认证", notes = "1:跳过, 0:不跳过")
            private Boolean skipCheck;
            @ApiModelProperty(value = "服务Api接口名称")
            private String serviceApiName;
            @Range(max = 1L, min = 0L)
            @ApiModelProperty(value = "启用状态", notes = "1:启用, 0:注销")
            private Integer status;
        }

        @Setter
        @Getter
        @ApiModel("服务Api创建参数")
        class Save {
            @ApiModelProperty(value = "服务Api接口类名路径")
            private String serviceApiPath;
            @ApiModelProperty(value = "请求url")
            private String serviceApiUrl;
            @ApiModelProperty(value = "Http请求方法")
            private RequestMethod requestMethod;
            @ApiModelProperty(value = "appid")
            private Long appId;
            @ApiModelProperty(value = "路由id")
            private Long routeId;
            @ApiModelProperty(value = "跳过鉴权", notes = "1:跳过, 0:不跳过")
            private Boolean skipAuth;
            @ApiModelProperty(value = "跳过认证", notes = "1:跳过, 0:不跳过")
            private Boolean skipCheck;
            @ApiModelProperty(value = "服务Api接口名称")
            private String serviceApiName;
            @Range(max = 1L, min = 0L)
            @ApiModelProperty(value = "启用状态", notes = "1:启用, 0:注销")
            private Integer status;
            @ApiModelProperty(value = "服务Api接口hash", hidden = true)
            private String hash;
            @ApiModelProperty(value = "接口批量绑定资源码")
            private BindResources bindResources;
        }

        @Setter
        @Getter
        @ApiModel("服务Api保存参数")
        class Update extends Save {
            @ApiModelProperty(value = "服务Api接口id")
            private Long serviceApiId;
        }

        @Setter
        @Getter
        @ApiModel("接口批量绑定资源码")
        class BindResources {
            @ApiModelProperty(value = "是否覆盖", notes = "是: 表示报文中的资源码id集合中不包含的关系会被删除,包含的会新增, 否: 只新增报文中包含的关系", example = "false")
            boolean isOverwrite;
            @ApiModelProperty(value = "资源码id集合")
            List<Long> resourceIds;
        }
    }

    interface Response {
        @Setter
        @Getter
        @EqualsAndHashCode(of = {"serviceApiId"})
        class ServiceApiWithResource {
            private Long serviceApiId;
            private String serviceApiUrl;
            private RequestMethod requestMethod;
            private Long routeId;
            private Boolean skipAuthentication;
            private Boolean skipAuthorization;
            private Integer timeout;
            private String serviceApiName;
            private Set<WithResource> resources;
            private Boolean forceAuthorize;
            public void addResource(WithResource resource) {
                if(this.resources == null) {
                    this.resources = Stream.of(resource).collect(Collectors.toSet());
                } else {
                    this.resources.add(resource);
                }
            }
        }

        @Setter
        @Getter
        @EqualsAndHashCode(of = {"resourceId"})
        class WithResource {
            private Long resourceId;
            private String resourceCode;
            private String resourceName;

        }
    }
}
