/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.route.api.common.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.validator.constraints.Range;
import org.springframework.web.bind.annotation.RequestMethod;

public interface ServiceApiModel {

    public static interface Response {

        public static class WithResource {
            private Long resourceId;
            private String resourceCode;
            private String resourceName;

            public void setResourceId(Long resourceId) {
                this.resourceId = resourceId;
            }

            public void setResourceCode(String resourceCode) {
                this.resourceCode = resourceCode;
            }

            public void setResourceName(String resourceName) {
                this.resourceName = resourceName;
            }

            public Long getResourceId() {
                return this.resourceId;
            }

            public String getResourceCode() {
                return this.resourceCode;
            }

            public String getResourceName() {
                return this.resourceName;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof WithResource)) {
                    return false;
                }
                WithResource other = (WithResource)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$resourceId = this.getResourceId();
                Long other$resourceId = other.getResourceId();
                return !(this$resourceId == null ? other$resourceId != null : !((Object)this$resourceId).equals(other$resourceId));
            }

            protected boolean canEqual(Object other) {
                return other instanceof WithResource;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $resourceId = this.getResourceId();
                result = result * 59 + ($resourceId == null ? 43 : ((Object)$resourceId).hashCode());
                return result;
            }
        }

        public static class ServiceApiWithResource {
            private Long serviceApiId;
            private String serviceApiUrl;
            private RequestMethod requestMethod;
            private Long routeId;
            private Boolean skipAuthentication;
            private Boolean skipAuthorization;
            private Integer timeout;
            private String serviceApiName;
            private Set<WithResource> resources;
            private Boolean forceAuthorize;

            public void addResource(WithResource resource) {
                if (this.resources == null) {
                    this.resources = Stream.of(resource).collect(Collectors.toSet());
                } else {
                    this.resources.add(resource);
                }
            }

            public void setServiceApiId(Long serviceApiId) {
                this.serviceApiId = serviceApiId;
            }

            public void setServiceApiUrl(String serviceApiUrl) {
                this.serviceApiUrl = serviceApiUrl;
            }

            public void setRequestMethod(RequestMethod requestMethod) {
                this.requestMethod = requestMethod;
            }

            public void setRouteId(Long routeId) {
                this.routeId = routeId;
            }

            public void setSkipAuthentication(Boolean skipAuthentication) {
                this.skipAuthentication = skipAuthentication;
            }

            public void setSkipAuthorization(Boolean skipAuthorization) {
                this.skipAuthorization = skipAuthorization;
            }

            public void setTimeout(Integer timeout) {
                this.timeout = timeout;
            }

            public void setServiceApiName(String serviceApiName) {
                this.serviceApiName = serviceApiName;
            }

            public void setResources(Set<WithResource> resources) {
                this.resources = resources;
            }

            public void setForceAuthorize(Boolean forceAuthorize) {
                this.forceAuthorize = forceAuthorize;
            }

            public Long getServiceApiId() {
                return this.serviceApiId;
            }

            public String getServiceApiUrl() {
                return this.serviceApiUrl;
            }

            public RequestMethod getRequestMethod() {
                return this.requestMethod;
            }

            public Long getRouteId() {
                return this.routeId;
            }

            public Boolean getSkipAuthentication() {
                return this.skipAuthentication;
            }

            public Boolean getSkipAuthorization() {
                return this.skipAuthorization;
            }

            public Integer getTimeout() {
                return this.timeout;
            }

            public String getServiceApiName() {
                return this.serviceApiName;
            }

            public Set<WithResource> getResources() {
                return this.resources;
            }

            public Boolean getForceAuthorize() {
                return this.forceAuthorize;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ServiceApiWithResource)) {
                    return false;
                }
                ServiceApiWithResource other = (ServiceApiWithResource)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$serviceApiId = this.getServiceApiId();
                Long other$serviceApiId = other.getServiceApiId();
                return !(this$serviceApiId == null ? other$serviceApiId != null : !((Object)this$serviceApiId).equals(other$serviceApiId));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ServiceApiWithResource;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $serviceApiId = this.getServiceApiId();
                result = result * 59 + ($serviceApiId == null ? 43 : ((Object)$serviceApiId).hashCode());
                return result;
            }
        }
    }

    public static interface Request {

        @ApiModel(value="\u63a5\u53e3\u6279\u91cf\u7ed1\u5b9a\u8d44\u6e90\u7801")
        public static class BindResources {
            @ApiModelProperty(value="\u662f\u5426\u8986\u76d6", notes="\u662f: \u8868\u793a\u62a5\u6587\u4e2d\u7684\u8d44\u6e90\u7801id\u96c6\u5408\u4e2d\u4e0d\u5305\u542b\u7684\u5173\u7cfb\u4f1a\u88ab\u5220\u9664,\u5305\u542b\u7684\u4f1a\u65b0\u589e, \u5426: \u53ea\u65b0\u589e\u62a5\u6587\u4e2d\u5305\u542b\u7684\u5173\u7cfb", example="false")
            boolean isOverwrite;
            @ApiModelProperty(value="\u8d44\u6e90\u7801id\u96c6\u5408")
            List<Long> resourceIds;

            public void setOverwrite(boolean isOverwrite) {
                this.isOverwrite = isOverwrite;
            }

            public void setResourceIds(List<Long> resourceIds) {
                this.resourceIds = resourceIds;
            }

            public boolean isOverwrite() {
                return this.isOverwrite;
            }

            public List<Long> getResourceIds() {
                return this.resourceIds;
            }
        }

        @ApiModel(value="\u670d\u52a1Api\u4fdd\u5b58\u53c2\u6570")
        public static class Update
        extends Save {
            @ApiModelProperty(value="\u670d\u52a1Api\u63a5\u53e3id")
            private Long serviceApiId;

            public void setServiceApiId(Long serviceApiId) {
                this.serviceApiId = serviceApiId;
            }

            public Long getServiceApiId() {
                return this.serviceApiId;
            }
        }

        @ApiModel(value="\u670d\u52a1Api\u521b\u5efa\u53c2\u6570")
        public static class Save {
            @ApiModelProperty(value="\u670d\u52a1Api\u63a5\u53e3\u7c7b\u540d\u8def\u5f84")
            private String serviceApiPath;
            @ApiModelProperty(value="\u8bf7\u6c42url")
            private String serviceApiUrl;
            @ApiModelProperty(value="Http\u8bf7\u6c42\u65b9\u6cd5")
            private RequestMethod requestMethod;
            @ApiModelProperty(value="appid")
            private Long appId;
            @ApiModelProperty(value="\u8def\u7531id")
            private Long routeId;
            @ApiModelProperty(value="\u8df3\u8fc7\u9274\u6743", notes="1:\u8df3\u8fc7, 0:\u4e0d\u8df3\u8fc7")
            private Boolean skipAuth;
            @ApiModelProperty(value="\u8df3\u8fc7\u8ba4\u8bc1", notes="1:\u8df3\u8fc7, 0:\u4e0d\u8df3\u8fc7")
            private Boolean skipCheck;
            @ApiModelProperty(value="\u670d\u52a1Api\u63a5\u53e3\u540d\u79f0")
            private String serviceApiName;
            @Range(max=1L, min=0L)
            @ApiModelProperty(value="\u542f\u7528\u72b6\u6001", notes="1:\u542f\u7528, 0:\u6ce8\u9500")
            private @Range(max=1L, min=0L) Integer status;
            @ApiModelProperty(value="\u670d\u52a1Api\u63a5\u53e3hash", hidden=true)
            private String hash;
            @ApiModelProperty(value="\u63a5\u53e3\u6279\u91cf\u7ed1\u5b9a\u8d44\u6e90\u7801")
            private BindResources bindResources;

            public void setServiceApiPath(String serviceApiPath) {
                this.serviceApiPath = serviceApiPath;
            }

            public void setServiceApiUrl(String serviceApiUrl) {
                this.serviceApiUrl = serviceApiUrl;
            }

            public void setRequestMethod(RequestMethod requestMethod) {
                this.requestMethod = requestMethod;
            }

            public void setAppId(Long appId) {
                this.appId = appId;
            }

            public void setRouteId(Long routeId) {
                this.routeId = routeId;
            }

            public void setSkipAuth(Boolean skipAuth) {
                this.skipAuth = skipAuth;
            }

            public void setSkipCheck(Boolean skipCheck) {
                this.skipCheck = skipCheck;
            }

            public void setServiceApiName(String serviceApiName) {
                this.serviceApiName = serviceApiName;
            }

            public void setStatus(Integer status) {
                this.status = status;
            }

            public void setHash(String hash) {
                this.hash = hash;
            }

            public void setBindResources(BindResources bindResources) {
                this.bindResources = bindResources;
            }

            public String getServiceApiPath() {
                return this.serviceApiPath;
            }

            public String getServiceApiUrl() {
                return this.serviceApiUrl;
            }

            public RequestMethod getRequestMethod() {
                return this.requestMethod;
            }

            public Long getAppId() {
                return this.appId;
            }

            public Long getRouteId() {
                return this.routeId;
            }

            public Boolean getSkipAuth() {
                return this.skipAuth;
            }

            public Boolean getSkipCheck() {
                return this.skipCheck;
            }

            public String getServiceApiName() {
                return this.serviceApiName;
            }

            public Integer getStatus() {
                return this.status;
            }

            public String getHash() {
                return this.hash;
            }

            public BindResources getBindResources() {
                return this.bindResources;
            }
        }

        @ApiModel(value="\u670d\u52a1Api\u67e5\u8be2\u53c2\u6570")
        public static class Query {
            @ApiModelProperty(value="\u79df\u6237id")
            private Long tenantId;
            @ApiModelProperty(value="\u8d44\u6e90\u7801id")
            private Long resourceId;
            @ApiModelProperty(value="\u8d44\u6e90\u7801code")
            private String resourceCode;
            @ApiModelProperty(value="\u670d\u52a1Api\u63a5\u53e3id")
            private Long serviceApiId;
            @ApiModelProperty(value="\u670d\u52a1Api\u63a5\u53e3\u7c7b\u540d\u8def\u5f84")
            private String serviceApiPath;
            @ApiModelProperty(value="\u8bf7\u6c42url")
            private String serviceApiUrl;
            @ApiModelProperty(value="Http\u8bf7\u6c42\u65b9\u6cd5")
            private RequestMethod requestMethod;
            @ApiModelProperty(value="appid")
            private Long appId;
            @ApiModelProperty(value="\u8def\u7531id")
            private Long routeId;
            @ApiModelProperty(value="\u8df3\u8fc7\u9274\u6743", notes="1:\u8df3\u8fc7, 0:\u4e0d\u8df3\u8fc7")
            private Boolean skipAuth;
            @ApiModelProperty(value="\u8df3\u8fc7\u8ba4\u8bc1", notes="1:\u8df3\u8fc7, 0:\u4e0d\u8df3\u8fc7")
            private Boolean skipCheck;
            @ApiModelProperty(value="\u670d\u52a1Api\u63a5\u53e3\u540d\u79f0")
            private String serviceApiName;
            @Range(max=1L, min=0L)
            @ApiModelProperty(value="\u542f\u7528\u72b6\u6001", notes="1:\u542f\u7528, 0:\u6ce8\u9500")
            private @Range(max=1L, min=0L) Integer status;

            public void setTenantId(Long tenantId) {
                this.tenantId = tenantId;
            }

            public void setResourceId(Long resourceId) {
                this.resourceId = resourceId;
            }

            public void setResourceCode(String resourceCode) {
                this.resourceCode = resourceCode;
            }

            public void setServiceApiId(Long serviceApiId) {
                this.serviceApiId = serviceApiId;
            }

            public void setServiceApiPath(String serviceApiPath) {
                this.serviceApiPath = serviceApiPath;
            }

            public void setServiceApiUrl(String serviceApiUrl) {
                this.serviceApiUrl = serviceApiUrl;
            }

            public void setRequestMethod(RequestMethod requestMethod) {
                this.requestMethod = requestMethod;
            }

            public void setAppId(Long appId) {
                this.appId = appId;
            }

            public void setRouteId(Long routeId) {
                this.routeId = routeId;
            }

            public void setSkipAuth(Boolean skipAuth) {
                this.skipAuth = skipAuth;
            }

            public void setSkipCheck(Boolean skipCheck) {
                this.skipCheck = skipCheck;
            }

            public void setServiceApiName(String serviceApiName) {
                this.serviceApiName = serviceApiName;
            }

            public void setStatus(Integer status) {
                this.status = status;
            }

            public Long getTenantId() {
                return this.tenantId;
            }

            public Long getResourceId() {
                return this.resourceId;
            }

            public String getResourceCode() {
                return this.resourceCode;
            }

            public Long getServiceApiId() {
                return this.serviceApiId;
            }

            public String getServiceApiPath() {
                return this.serviceApiPath;
            }

            public String getServiceApiUrl() {
                return this.serviceApiUrl;
            }

            public RequestMethod getRequestMethod() {
                return this.requestMethod;
            }

            public Long getAppId() {
                return this.appId;
            }

            public Long getRouteId() {
                return this.routeId;
            }

            public Boolean getSkipAuth() {
                return this.skipAuth;
            }

            public Boolean getSkipCheck() {
                return this.skipCheck;
            }

            public String getServiceApiName() {
                return this.serviceApiName;
            }

            public Integer getStatus() {
                return this.status;
            }
        }
    }
}

