package com.xforceplus.route.api;

import com.xforceplus.route.api.common.Uri;
import com.xforceplus.route.api.common.model.RouteModel.Request.*;
import com.xforceplus.domain.route.RouteDto;
import com.xforceplus.tenant.security.core.api.response.ResponseEntity;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * @author geewit
 */
public interface RouteApi {
    interface Path extends Uri {
        String API_PREFIX = PATH_PREFIX + PATH_GLOBAL + API_VERSION + "/routes";
        String PAGE = API_PREFIX;
        String LIST = API_PREFIX + "/list";
        String CREATE = API_PREFIX;
        String UPDATE = API_PREFIX + "/{id}";
        String DELETE = API_PREFIX + "/{id}";
    }

    @ResponseBody
    @RequestMapping(name = "路由分页列表", value = Path.PAGE, method = RequestMethod.GET)
    <T extends RouteDto> ResponseEntity<Page<T>> page(@SpringQueryMap Query query, Pageable pageable);

    @ResponseBody
    @RequestMapping(name = "路由列表", value = Path.LIST, method = RequestMethod.GET)
    <T extends RouteDto> ResponseEntity<List<T>> list(@SpringQueryMap Query query, Sort sort);

    @ResponseBody
    @RequestMapping(name = "新增路由", value = Path.CREATE, method = RequestMethod.POST)
    <T extends RouteDto> ResponseEntity<T> create(@Valid @RequestBody Save route);

    @ResponseBody
    @RequestMapping(name = "更新路由", value = Path.UPDATE, method = RequestMethod.PUT)
    <T extends RouteDto> ResponseEntity<T> update(@PathVariable("id") Long id, @RequestBody Save route);

    @ResponseBody
    @RequestMapping(name = "删除路由", value = Path.DELETE, method = RequestMethod.DELETE)
    ResponseEntity<String> delete(@PathVariable("id") Long id);
}
