/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.route.listener;

import com.xforceplus.route.event.RefreshingRoutesEvent;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.stereotype.Service;

@Service
public class RefreshingRouteMessageSubscriber
implements ApplicationEventPublisherAware,
MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(RefreshingRouteMessageSubscriber.class);
    protected ApplicationEventPublisher publisher;

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    public void onMessage(Message message, byte[] pattern) {
        String refreshId = new String(message.getBody(), StandardCharsets.UTF_8);
        logger.info("onMessage with redis expire: " + refreshId);
        this.publisher.publishEvent((ApplicationEvent)new RefreshingRoutesEvent(this));
        logger.info("----------refresh route done-----------{}", (Object)refreshId);
    }
}

