/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.route.confg;

import com.xforceplus.route.listener.RefreshingRouteMessageSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;

@Configuration
public class RefreshingRouteConfig
implements ApplicationEventPublisherAware {
    private static final Logger logger = LoggerFactory.getLogger(RefreshingRouteConfig.class);
    private ApplicationEventPublisher applicationEventPublisher;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Bean(value={"refreshingRouteTopic"})
    public ChannelTopic topic() {
        return new ChannelTopic("route:refresh");
    }

    @Bean(value={"refreshingRouteRedisMessageListenerContainer"})
    public RedisMessageListenerContainer refreshingRouteRedisMessageListenerContainer(RedisConnectionFactory connectionFactory, @Qualifier(value="refreshingRouteTopic") ChannelTopic topic) {
        logger.info("RedisMessageListenerContainer add messageListener");
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(connectionFactory);
        RefreshingRouteMessageSubscriber messageSubscriber = new RefreshingRouteMessageSubscriber();
        messageSubscriber.setApplicationEventPublisher(this.applicationEventPublisher);
        MessageListenerAdapter messageListenerAdapter = new MessageListenerAdapter((Object)messageSubscriber);
        container.addMessageListener((MessageListener)messageListenerAdapter, (Topic)topic);
        return container;
    }
}

