package com.xforceplus.domain.resource;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.core.domain.IOperator;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;
import java.util.Objects;

/***
 * @author geewit
 */
@SuppressWarnings("all")
@ApiModel("资源码")
public class ResourceDto<T extends ResourceDto<T>> implements IOperator {
    @ApiModelProperty("资源码id")
    @JsonView(View.class)
    protected Long resourceId;

    @ApiModelProperty("appid")
    @JsonView(View.class)
    protected Long appId;

    @ApiModelProperty("appName")
    @JsonView(View.class)
    protected String appName;

    @ApiModelProperty("资源码")
    @JsonView(View.class)
    protected String resourceCode;

    @ApiModelProperty("资源码名称")
    @JsonView(View.class)
    protected String resourceName;

    @ApiModelProperty("所属平台")
    @JsonView(View.class)
    protected Integer resourcePlatform;

    @ApiModelProperty("资源码类型")
    @JsonView(View.class)
    protected Integer resourceType;

    @ApiModelProperty("上级资源码id")
    @JsonView(View.class)
    protected Long parentId;

    @ApiModelProperty(value = "启用状态", notes = "1:启用, 0:注销")
    @JsonView(View.class)
    protected Integer status;

    @ApiModelProperty(value = "是否属于公司服务包", notes = "1:是, 0:否")
    @JsonView(View.class)
    protected Boolean isServicePackage;

    @ApiModelProperty("下级资源码集合")
    @JsonView(View.Tree.class)
    protected List<T> children;

    @JsonView(View.class)
    @ApiModelProperty(value = "创建人id")
    protected String createrId;

    @JsonView(View.class)
    @ApiModelProperty(value = "创建人名称")
    protected String createrName;

    @ApiModelProperty(value = "创建时间")
    @JsonView(View.class)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    @JsonView(View.class)
    @ApiModelProperty(value = "更新人id")
    protected String updaterId;

    @JsonView(View.class)
    @ApiModelProperty(value = "更新人名称")
    protected String updaterName;

    @JsonView({View.class})
    @ApiModelProperty(value = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    public Long getResourceId() {
        return resourceId;
    }

    public void setResourceId(Long resourceId) {
        this.resourceId = resourceId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getResourceCode() {
        return resourceCode;
    }

    public void setResourceCode(String resourceCode) {
        this.resourceCode = resourceCode;
    }

    public String getResourceName() {
        return resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public Integer getResourcePlatform() {
        return resourcePlatform;
    }

    public void setResourcePlatform(Integer resourcePlatform) {
        this.resourcePlatform = resourcePlatform;
    }

    public Integer getResourceType() {
        return resourceType;
    }

    public void setResourceType(Integer resourceType) {
        this.resourceType = resourceType;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @Override
    public String getCreaterId() {
        return createrId;
    }

    @Override
    public void setCreaterId(String createrId) {
        this.createrId = createrId;
    }

    @Override
    public String getCreaterName() {
        return createrName;
    }

    @Override
    public void setCreaterName(String createrName) {
        this.createrName = createrName;
    }

    @Override
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String getUpdaterId() {
        return updaterId;
    }

    @Override
    public void setUpdaterId(String updaterId) {
        this.updaterId = updaterId;
    }

    @Override
    public String getUpdaterName() {
        return updaterName;
    }

    @Override
    public void setUpdaterName(String updaterName) {
        this.updaterName = updaterName;
    }

    @Override
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Boolean getIsServicePackage() {
        return isServicePackage;
    }

    public void setIsServicePackage(Boolean isServicePackage) {
        this.isServicePackage = isServicePackage;
    }

    public List<T> getChildren() {
        return children;
    }

    public void setChildren(List<T> children) {
        this.children = children;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof ResourceDto)) return false;
        ResourceDto<?> that = (ResourceDto<?>) o;
        if (this.resourceId != null && that.resourceId != null) {
            return this.resourceId.equals(that.resourceId);
        }

        return this.appId.equals(that.appId) && this.resourceCode.equals(that.resourceCode);
    }

    @Override
    public int hashCode() {
        if (this.resourceId != null) {
            return Objects.hashCode(this.resourceId);
        }
        return Objects.hash(this.appId, this.resourceCode);
    }
}
