package com.xforceplus.domain.route;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;
import lombok.Setter;

import java.util.*;

/**
 * @author geewit
 */
@Setter
@Getter
public class RouteDto {
    /**
     * 路由id
     */
    protected Long routeId;
    /**
     * appId
     */
    protected Long appId;
    /**
     * 路由名称
     */
    protected String routeName;
    /**
     * 路由地址
     */
    protected String path;
    /**
     * 服务地址
     */
    protected String url;
    /**
     * 是否静态
     */
    protected Boolean isStatic;

    /**
     * 是否精确匹配
     */
    protected Boolean isExactMatch;

    /**
     * 是否需要运营人员认证
     */
    protected Boolean isOperator;
    protected String createUserId;
    protected String createUserName;
    protected Integer status;
    protected String groupType;
    protected Boolean billable;
    protected Boolean skipAuthentication;
    protected Boolean skipAuthorization;
    protected String hash;
    protected Integer timeout;
    /**
     * 开启自动扫描
     */
    protected Boolean enableAutoscan;

    /**
     * 是否开启强制路由鉴权
     */
    protected Boolean forceAuthorize;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08")
    protected Date createTime;

    @Override
    public String toString() {
        return "RouteDto{" +
                "routeId=" + routeId +
                ", appId=" + appId +
                ", routeName='" + routeName + '\'' +
                ", path='" + path + '\'' +
                ", url='" + url + '\'' +
                ", isStatic=" + isStatic +
                ", isExactMatch=" + isExactMatch +
                ", isOperator=" + isOperator +
                ", createUserId='" + createUserId + '\'' +
                ", createUserName='" + createUserName + '\'' +
                ", status=" + status +
                ", groupType='" + groupType + '\'' +
                ", billable=" + billable +
                ", skipAuthentication=" + skipAuthentication +
                ", skipAuthorization=" + skipAuthorization +
                ", enableAutoscan=" + enableAutoscan +
                ", createTime=" + createTime +
                ", hash=" + hash +
                ", timeout=" + timeout +
                ", forceAuthorize=" + forceAuthorize +
                '}';
    }
}
