package com.xforceplus.domain.route;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.core.domain.IOperator;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.Date;

/***
 * @author geewit
 */
@Setter
@Getter
@ApiModel("服务Api接口")
public class ServiceApiDto implements IOperator {
    @ApiModelProperty(value = "服务Api接口id")
    protected Long serviceApiId;

    @ApiModelProperty(value = "服务Api接口类名路径")
    protected String serviceApiPath;

    @ApiModelProperty(value = "请求url")
    protected String serviceApiUrl;

    @ApiModelProperty(value = "Http请求方法")
    protected RequestMethod requestMethod;

    @ApiModelProperty(value = "appid")
    protected Long appId;

    @ApiModelProperty("appName")
    @JsonView(View.class)
    protected String appName;

    @ApiModelProperty(value = "路由id")
    protected Long routeId;

    @ApiModelProperty(value = "跳过认证", notes = "1:跳过, 0:不跳过")
    protected Boolean skipAuthentication;

    @ApiModelProperty(value = "跳过鉴权", notes = "1:跳过, 0:不跳过")
    protected Boolean skipAuthorization;

    @ApiModelProperty(value = "服务Api接口名称")
    protected String serviceApiName;

    @ApiModelProperty(value = "服务Api接口超时时间(毫秒)")
    protected Integer timeout;

    @ApiModelProperty(value = "启用状态", notes = "1:启用, 0:注销")
    protected Integer status;

    @ApiModelProperty(value = "hash", notes = "唯一标识")
    protected String hash;

    @ApiModelProperty(value = "创建人id")
    protected String createrId;

    @ApiModelProperty(value = "创建人名称")
    protected String createrName;

    @JsonView({View.class})
    @ApiModelProperty(value = "创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    @ApiModelProperty(value = "更新人id")
    protected String updaterId;

    @ApiModelProperty(value = "更新人名称")
    protected String updaterName;

    @ApiModelProperty(value = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;
}
