package com.xforceplus.domain.app;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.Objects;

/**
 * @author geewit
 */
@Setter
@Getter
public class AppDto {
    public AppDto() {
    }

    public AppDto(Long appId, String appName) {
        this.appId = appId;
        this.appName = appName;
    }

    protected Long appId;
    protected String appName;
    protected Integer status;
    protected String resourcePrefix;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonView({View.Info.class})
    @ApiModelProperty(value = "创建时间")
    protected Date createTime;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AppDto appDto = (AppDto) o;
        return Objects.equals(appId, appDto.appId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appId);
    }
}
