package com.xforceplus.domain.resource;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.tenant.security.core.domain.IOperator;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.Objects;

/**
 * @author geewit
 */
@SuppressWarnings("all")
@ApiModel("资源码")
@Setter
@Getter
public class ResourceDto implements IOperator {
    @ApiModelProperty("资源码id")
    @JsonView(View.class)
    protected Long resourceId;

    @ApiModelProperty("appid")
    @JsonView(View.class)
    protected Long appId;

    @ApiModelProperty("appName")
    @JsonView(View.class)
    protected String appName;

    @ApiModelProperty("资源码")
    @JsonView(View.class)
    protected String resourceCode;

    @ApiModelProperty("资源码名称")
    @JsonView(View.class)
    protected String resourceName;

    @ApiModelProperty("所属平台")
    @JsonView(View.class)
    protected Integer resourcePlatform;

    @ApiModelProperty("资源码类型")
    @JsonView(View.class)
    protected Integer resourceType;

    @ApiModelProperty("上级资源码id")
    @JsonView(View.class)
    protected Long parentId;

    @ApiModelProperty("上级资源码名称")
    @JsonView(View.class)
    protected String parentName;

    @ApiModelProperty(value = "启用状态", notes = "1:启用, 0:注销")
    @JsonView(View.class)
    protected Integer status;

    @ApiModelProperty(value = "是否属于公司服务包", notes = "1:是, 0:否")
    @JsonView(View.class)
    protected Boolean isServicePackage;

    @JsonView(View.class)
    @ApiModelProperty(value = "创建人id")
    protected String createrId;

    @JsonView(View.class)
    @ApiModelProperty(value = "创建人名称")
    protected String createrName;

    @ApiModelProperty(value = "创建时间")
    @JsonView(View.class)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    @JsonView(View.class)
    @ApiModelProperty(value = "更新人id")
    protected String updaterId;

    @JsonView(View.class)
    @ApiModelProperty(value = "更新人名称")
    protected String updaterName;

    @JsonView({View.class})
    @ApiModelProperty(value = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof ResourceDto)) return false;
        ResourceDto that = (ResourceDto) o;
        if (this.resourceId != null && that.resourceId != null) {
            return this.resourceId.equals(that.resourceId);
        }

        return this.appId.equals(that.appId) && this.resourceCode.equals(that.resourceCode);
    }

    @Override
    public int hashCode() {
        if (this.resourceId != null) {
            return Objects.hashCode(this.resourceId);
        }
        return Objects.hash(this.appId, this.resourceCode);
    }
}
