package com.xforceplus.domain.route;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;
import lombok.Setter;

import java.util.Date;

/**
 * @author geewit
 */
@Setter
@Getter
public class RouteApplyDto {
    /**
     * 路由申请id
     */
    protected Long routeApplyId;
    /**
     * appId
     */
    protected Integer appId;
    /**
     * 路由名称
     */
    protected String routeName;
    /**
     * 路由地址
     */
    protected String path;
    /**
     * 服务地址
     */
    protected String url;
    /**
     * 是否静态
     */
    protected Boolean isStatic;
    /**
     * 是否精确匹配
     */
    protected Boolean isExactMatch;
    /**
     * 是否需要运营人员认证
     */
    protected Boolean isOperator;
    /**
     * createUserId
     */
    protected String createUserId;
    protected String createUserName;
    protected Integer status;
    protected String groupType;
    protected Boolean billable;
    protected Boolean skipAuthentication;
    protected Boolean skipAuthorization;
    protected String hash;
    protected Integer timeout;
    /**
     * 开启自动扫描
     */
    protected Boolean enableAutoscan;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08")
    protected Date createTime;
}
