package com.xforceplus.domain.route;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;
import lombok.Setter;

import java.util.*;

/**
 * @author geewit
 */
@Setter
@Getter
public class RouteDto {
    /**
     * 路由id
     */
    protected Long routeId;
    /**
     * appId
     */
    protected Long appId;
    /**
     * 路由名称
     */
    protected String routeName;
    /**
     * 路由地址
     */
    protected String path;
    /**
     * 服务地址
     */
    protected String url;
    /**
     * 是否静态
     */
    protected Boolean isStatic;
    /**
     * 是否精确匹配
     */
    protected Boolean isExactMatch;
    /**
     * 是否需要运营人员认证
     */
    protected Boolean isOperator;
    protected String createUserId;
    protected String createUserName;
    protected Integer status;
    protected String groupType;
    protected Boolean billable;
    /**
     * 是否跳过认证
     */
    protected Boolean skipAuthentication;
    /**
     * 是否跳过鉴权
     */
    protected Boolean skipAuthorization;
    /**
     * 通过
     */
    protected String hash;
    /**
     * 超时配置
     */
    protected Integer timeout;
    /**
     * 开启自动扫描
     */
    protected Boolean enableAutoscan;
    /**
     * 是否开启强制路由鉴权
     */
    protected Boolean forceAuthorize;
    /**
     * 联系人
     */
    protected String contact;

    /**
     * 联系人团队
     */
    protected String contactTeam;

    /**
     * 健康检查地址
     */
    protected String healthPath;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+08")
    protected Date createTime;

    @Override
    public String toString() {
        return "RouteDto{" +
                "routeId=" + routeId +
                ", appId=" + appId +
                ", routeName='" + routeName + '\'' +
                ", path='" + path + '\'' +
                ", url='" + url + '\'' +
                ", isStatic=" + isStatic +
                ", isExactMatch=" + isExactMatch +
                ", isOperator=" + isOperator +
                ", groupType='" + groupType + '\'' +
                ", billable=" + billable +
                ", skipAuthentication=" + skipAuthentication +
                ", skipAuthorization=" + skipAuthorization +
                ", enableAutoscan=" + enableAutoscan +
                ", timeout=" + timeout +
                ", forceAuthorize=" + forceAuthorize +
                ", healthPath=" + healthPath +
                ", contact=" + contact +
                ", status=" + status +
                ", contactTeam=" + contactTeam +
                ", createUserId='" + createUserId + '\'' +
                ", createUserName='" + createUserName + '\'' +
                ", createTime=" + createTime +
                '}';
    }
}
