/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.route.jpa.listener;

import com.xforceplus.tenant.route.entity.Route;
import com.xforceplus.tenant.route.utils.RouteUtils;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.PrePersist;
import org.apache.commons.lang3.StringUtils;

public class RouteListener {
    @PrePersist
    public void prePersist(Route route) {
        IAuthorizedUser user;
        if (route.getCreateTime() == null) {
            Date now = Calendar.getInstance().getTime();
            route.setCreateTime(now);
        }
        if (route.getCreateUserId() == null && (user = UserInfoHolder.get()) != null) {
            route.setCreateUserId(String.valueOf(user.getId()));
            route.setCreateUserName(user.getUsername());
        }
        if (StringUtils.isNotBlank((CharSequence)route.getPath()) && StringUtils.isBlank((CharSequence)route.getPath())) {
            String hash = RouteUtils.hash(route.getPath());
            route.setHash(hash);
        }
    }
}

