/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.tenant.route.query;

import com.xforceplus.route.api.common.model.RouteModel;
import com.xforceplus.tenant.route.entity.Route;
import java.io.Serializable;
import java.util.ArrayList;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

public class RouteQueryHelper {
    public static Specification<Route> querySpecification(RouteModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (query.getRouteId() != null && query.getRouteId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("routeId"), (Object)query.getRouteId()));
            } else {
                if (StringUtils.isNotBlank((CharSequence)query.getRouteName())) {
                    predicates.add(builder.like((Expression)root.get("routeName"), "%" + query.getRouteName() + "%"));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getPath())) {
                    predicates.add(builder.like((Expression)root.get("path"), "%" + query.getPath() + "%"));
                }
                if (query.getAppId() != null && query.getAppId() > 0L) {
                    predicates.add(builder.equal((Expression)root.get("appId"), (Object)query.getAppId()));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getUrl())) {
                    predicates.add(builder.like((Expression)root.get("url"), "%" + query.getUrl() + "%"));
                }
                if (query.getIsStatic() != null) {
                    predicates.add(builder.equal((Expression)root.get("isStatic"), (Object)query.getIsStatic()));
                }
                if (query.getIsExactMatch() != null) {
                    predicates.add(builder.equal((Expression)root.get("isExactMatch"), (Object)query.getIsExactMatch()));
                }
                if (query.getStatus() != null) {
                    predicates.add(builder.equal((Expression)root.get("status"), (Object)query.getStatus()));
                }
                if (query.getBillable() != null) {
                    predicates.add(builder.equal((Expression)root.get("billable"), (Object)query.getBillable()));
                }
                if (query.getSkipAuthentication() != null) {
                    predicates.add(builder.equal((Expression)root.get("skipAuthentication"), (Object)query.getSkipAuthentication()));
                }
                if (query.getSkipAuthorization() != null) {
                    predicates.add(builder.equal((Expression)root.get("skipAuthorization"), (Object)query.getSkipAuthorization()));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getGroupType())) {
                    predicates.add(builder.equal((Expression)root.get("groupType"), (Object)query.getGroupType()));
                }
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}

