/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.domain.route.ServiceApiDto;
import com.xforceplus.entity.App;
import com.xforceplus.entity.ResourceApiRel;
import com.xforceplus.jpa.listener.ServiceApiListener;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.ConstraintMode;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedAttributeNode;
import javax.persistence.NamedEntityGraph;
import javax.persistence.NamedEntityGraphs;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.springframework.web.bind.annotation.RequestMethod;

@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown=true)
@NamedEntityGraphs(value={@NamedEntityGraph(name="ServiceApi.graph", attributeNodes={@NamedAttributeNode(value="app")})})
@EntityListeners(value={ServiceApiListener.class})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name="sys_service_api")
public class ServiceApi
extends ServiceApiDto
implements Serializable {
    @JsonIgnore
    private App app;
    @JsonIgnore
    private List<ResourceApiRel> resourceApiRels;

    @Id
    @Column(name="service_api_id", nullable=false)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="SnowflakeGenerator")
    @GenericGenerator(name="SnowflakeGenerator", strategy="io.geewit.data.jpa.essential.id.SnowflakeGenerator")
    public Long getServiceApiId() {
        return this.serviceApiId;
    }

    @Basic
    @Column(name="service_api_path", nullable=false)
    public String getServiceApiPath() {
        return this.serviceApiPath;
    }

    @Basic
    @Column(name="service_api_url", nullable=false)
    public String getServiceApiUrl() {
        return this.serviceApiUrl;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="request_method", nullable=false)
    public RequestMethod getRequestMethod() {
        return this.requestMethod;
    }

    @Basic
    @Column(name="app_id")
    public Long getAppId() {
        return this.appId != null && this.appId > 0L ? this.appId : null;
    }

    @Basic
    @Column(name="route_id")
    public Long getRouteId() {
        return this.routeId;
    }

    @Basic
    @Column(name="skip_authentication")
    public Boolean getSkipAuthentication() {
        return this.skipAuthentication;
    }

    @Basic
    @Column(name="skip_authorization")
    public Boolean getSkipAuthorization() {
        return this.skipAuthorization;
    }

    @Basic
    @Column(name="service_api_name", nullable=false)
    public String getServiceApiName() {
        return this.serviceApiName;
    }

    @Basic
    @Column(name="timeout")
    public Integer getTimeout() {
        return this.timeout;
    }

    @Basic
    @Column(name="status", nullable=false)
    public Integer getStatus() {
        return this.status;
    }

    @Basic
    @Column(name="hash")
    public String getHash() {
        return this.hash;
    }

    @Basic
    @Column(name="create_user_id", updatable=false)
    public String getCreaterId() {
        return this.createrId;
    }

    @Basic
    @Column(name="create_user_name", updatable=false)
    public String getCreaterName() {
        return this.createrName;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="create_time", updatable=false)
    public Date getCreateTime() {
        return this.createTime;
    }

    @Basic
    @Column(name="update_user_id")
    public String getUpdaterId() {
        return this.updaterId;
    }

    @Basic
    @Column(name="update_user_name")
    public String getUpdaterName() {
        return this.updaterName;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="update_time")
    public Date getUpdateTime() {
        return this.updateTime;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="app_id", referencedColumnName="app_id", insertable=false, updatable=false, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT))
    @NotFound(action=NotFoundAction.IGNORE)
    public App getApp() {
        return this.app;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="serviceApi")
    public List<ResourceApiRel> getResourceApiRels() {
        return this.resourceApiRels;
    }

    @Transient
    public String getAppName() {
        if (this.appName == null && this.app != null) {
            this.appName = this.app.getAppName();
        }
        return this.appName;
    }

    @JsonIgnore
    public void setApp(App app) {
        this.app = app;
    }

    @JsonIgnore
    public void setResourceApiRels(List<ResourceApiRel> resourceApiRels) {
        this.resourceApiRels = resourceApiRels;
    }
}

